package com.biz.eisp.activiti.designer.processcheck.batchck;

import java.util.List;

/**
 * 批量检测执行线程类
 * @author LeoWen
 * @date 2017年9月13日 下午9:52:29
 */
public class BatchCheckProThread extends Thread{

	private BatchCheckProDeal deal;
	
	/**
	 * 批次处理用户检测数据大小
	 */
	private int batchSize = 5;
	
	public BatchCheckProThread(BatchCheckProDeal deal) {
		this.deal = deal;
	}
	
	public void run() {
		List<String> users;
		while (true){
			users = deal.getUsers();
			if(users == null) break;
			//分多少批次处理
			int batchNum = users.size() % batchSize == 0 ? users.size() / batchSize : (users.size() / batchSize) + 1;
			for(int i = 0; i < batchNum; i ++){
				int startNum = i * batchSize;//截取起始角标
				int endNum = startNum + batchSize;//截取结束角标
				endNum = endNum > users.size() ? users.size() : endNum;
				try {
					deal.batchChecks(users.subList(startNum, endNum));//批量保存执行
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}
}
