package com.biz.eisp.activiti.designer.processcheck.controller;

import com.biz.eisp.activiti.designer.processcheck.batchck.BatchCheckProDeal;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckDetail;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckRecord;
import com.biz.eisp.activiti.designer.processcheck.service.TaProcessCheckService;
import com.biz.eisp.activiti.designer.processcheck.vo.ProcCkQuerySetVo;
import com.biz.eisp.activiti.designer.processcheck.vo.TaProcessCkRecordVo;
import com.biz.eisp.activiti.util.DateUtils;
import com.biz.eisp.activiti.util.EhcacheUtil;
import com.biz.eisp.activiti.util.JsonUtil;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.web.BaseController;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * 流程检测Controller.
 * <p>
 *
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taProcessCheckController")
public class TaProcessCheckController extends BaseController{

	private static final Logger logger = LoggerFactory.getLogger(TaProcessCheckController.class);
	
	@Autowired
	private TaProcessCheckService taProcessCheckService;
	@Autowired
	private TaskService taskService;
	
	/**
	 * 跳转到流程检测
	 * 
	 * @param request
	 * @param processKey
	 * @return
	 */
	@RequestMapping(value = "processcheckView", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView processcheckView(HttpServletRequest request, String processKey){
		try {
			TaProcessCkRecordVo vo = taProcessCheckService.createProcessCheck(processKey);
			request.setAttribute("processCkRecord", JsonUtil.toJson(vo));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new ModelAndView("com/biz/eisp/activiti/designer/processcheck/processCheckView");
	}
	
	/**
	 * 参数设置
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "checkQuerySet", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView checkQuerySet(HttpServletRequest request){
		try {
			String title = request.getParameter("title");
			String processId = request.getParameter("processId");
			request.setAttribute("title", title);
			List<ProcCkQuerySetVo> list = taProcessCheckService.checkQuerySet(processId);
			request.setAttribute("processCkParams", JsonUtil.toJson(list));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new ModelAndView("com/biz/eisp/activiti/designer/processcheck/processCkQuerySet");
	}
	
	/**
	 * 保存检测记录
	 * 
	 * @param request
	 * @param processId
	 * @return
	 */
	@RequestMapping(value = "saveCkRecord", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveCkRecord(HttpServletRequest request, 
			String processId, String proCkQuerySet){
		AjaxJson aj = new AjaxJson("保存检测记录成功");
		aj.setSuccess(true);
		try {
			aj.setObj(taProcessCheckService.saveRecord(processId, proCkQuerySet));
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg("保存检测记录失败");
		}
		return aj;
	}
	
	/**
	 * 生成报告
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "updateCkRecord", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson updateCkRecord(HttpServletRequest request,TaProcessCheckRecord entity){
		AjaxJson aj = new AjaxJson("生成报告成功");
		aj.setSuccess(true);
		try {
			taProcessCheckService.updateCkRecord(entity);
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg("生成报告失败");
		}
		return aj;
	}
	
	/**
	 * 保存中断节点记录
	 * 
	 * @param request
	 * @param nodeCode
	 * @param recordId
	 * @param allCkState
	 * @return
	 */
	@RequestMapping(value = "saveStopedNode", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveStopedNode(HttpServletRequest request, String isStopCheck,
			String nodeCode, String recordId, String allCkState){
		AjaxJson aj = new AjaxJson("保存中断节点记录成功");
		aj.setSuccess(true);
		TaProcessCheckDetail detail = taProcessCheckService.findCheckDetail(nodeCode, recordId);
		try {
			detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), DateUtils.DEFAULT_DATE_ALL_PATTERN));
			detail.setState("3");
			String remark = "<p><span style=\"color: blue;\">节点检测中断";
			if("true".equals(isStopCheck)){
	    		remark = remark + "，原因：中途停止检测，被迫中断！";
	    	}else if("1".equals(allCkState)){// 成功后的部分中断
	    		remark = remark + "，原因：未自动找到该节点任务，可能该节点为条件参数的分支节点，请重新设置分支参数再检测！";
	    	}else{
	    		remark = remark + "，原因：中途节点检测失败，被迫中断！";
	    	}
	    	
	    	remark = remark + "</span></p><p>-----------------------------------------</p>";
			detail.setCheckResult(remark);
			taProcessCheckService.updateEntity(detail);
			aj.setObj(detail);
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg("保存中断节点记录失败");
		}
		return aj;
	}
	
	/**
	 * 流程通过检测
	 * 
	 * @param request
	 * @param recordId
	 * @return
	 */
	@SuppressWarnings("finally")
	@RequestMapping(value = "passCkReq", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson passCkReq(HttpServletRequest request, String nodeCode, String recordId){
		AjaxJson aj = new AjaxJson("检测记录成功");
		aj.setSuccess(true);
		TaProcessCheckDetail detail = taProcessCheckService.findCheckDetail(nodeCode, recordId);
		try {
			detail = taProcessCheckService.passCkReq(detail);
			String procInsId = detail.getProcessInsId();
			List<Task> nextTasks = taskService.createTaskQuery().processInstanceId(procInsId).list();
			if(nextTasks.size() > 0){
				detail.setNextNode(nextTasks.get(0).getTaskDefinitionKey());
			}
		} catch (Exception e) {
			e.printStackTrace();
			aj.setSuccess(false);
			aj.setMsg(e.getMessage());
		} finally {
			taProcessCheckService.updateEntity(detail);
			aj.setObj(detail);
			return aj;
		}
	}
	
	/**
	 * 加载历史记录
	 * 
	 * @param request
	 * @param processId
	 * @return
	 */
	@RequestMapping(value = "loadHisRecord", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public List<TaProcessCkRecordVo> loadHisRecord(HttpServletRequest request, String processId){
		TaProcessCkRecordVo vo = new TaProcessCkRecordVo();
		vo.setProcessId(processId);
		vo.setState("1");
		List<TaProcessCkRecordVo> list = taProcessCheckService.getCkRecords(vo);
		vo.setState("2");
		list.addAll(taProcessCheckService.getCkRecords(vo));
		return list;
	}
	
	/**
	 * 历史报告删除
	 * 
	 * @param request
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "deleteHis", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteHis(HttpServletRequest request,String id){
		AjaxJson aj = new AjaxJson("删除报告成功");
		aj.setSuccess(true);
		try {
			taProcessCheckService.deleteHis(id);
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg("删除报告失败");
		}
		return aj;
	}
	
	/**
	 * 历史报告查看
	 * 
	 * @param request
	 * @param recordId
	 * @return
	 */
	@RequestMapping(value = "openHis", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView openHis(HttpServletRequest request, String recordId){
		String url = "com/biz/eisp/activiti/designer/processcheck/processCkHisDetail";
		try {
			TaProcessCkRecordVo vo = taProcessCheckService.findRecordDetail(recordId);
			if(vo.getIsBatchUser() != null && vo.getIsBatchUser() == 1){
				url = "com/biz/eisp/activiti/designer/processcheck/procCkBatchHisDetail";
			}
			request.setAttribute("processCkRecord", JsonUtil.toJson(vo));
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new ModelAndView(url);
	}
	
	/**
	 * 
	 * @param request
	 * @param processId
	 * @param proCkQuerySet
	 * @return
	 */
	@RequestMapping(value = "toBatchCheck", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson toBatchCheck(HttpServletRequest request, 
			String processId, String proCkQuerySet){
		AjaxJson aj = new AjaxJson("批量检测开始成功");
		aj.setSuccess(true);
		try {
			String batchId = UUID.randomUUID().toString().replace("-", "");
			TaProcessCkRecordVo vo = (TaProcessCkRecordVo) EhcacheUtil.getItem("PRO_CK_" + processId);
			vo.setId(batchId);
			vo.setTitle(vo.getTitle());
			vo.setCkParams(proCkQuerySet);
			vo.setIsBatchUser(1);
			vo.setCheckTime(DateUtils.getFormatDateStr(new Date(), DateUtils.DEFAULT_DATE_ALL_PATTERN));
			String modelDetails = JsonUtil.toJson(vo.getCkPassDetails());
			vo.setCkPassDetails(new ArrayList<TaProcessCheckDetail>());
			List<String> users = taProcessCheckService.getBatchUserIds(proCkQuerySet);
			vo.setUsers(users);
			for(String user : users){
				@SuppressWarnings("unchecked")
				List<TaProcessCheckDetail> details = (List<TaProcessCheckDetail>) JsonUtil.toObjectArrayListFromJson(
						modelDetails, new TypeReference<List<TaProcessCheckDetail>>() {});
				for(TaProcessCheckDetail detail : details){
					detail.setUserName(user);
				}
				vo.getCkPassDetails().addAll(details);
			}
			EhcacheUtil.putItem("PRO_CK_" + batchId, vo);
			EhcacheUtil.putItem("PRO_CK_PG_ALL_" + batchId, vo.getCkPassDetails().size());
			EhcacheUtil.putItem("PRO_CK_PG_SUCC_" + batchId, 0);
			EhcacheUtil.putItem("PRO_CK_PG_FAIL_" + batchId, 0);
			EhcacheUtil.putItem("PRO_CK_PG_STOP_" + batchId, 0);
			new BatchCheckProDeal(users, batchId).execute();
			aj.setObj(batchId);
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg("批量检测异常");
		}
		return aj;
	}
	
	/**
	 * 批量检测进度情况获取
	 * 
	 * @param request
	 * @param batchId
	 * @return
	 */
	@RequestMapping(value = "batchProgress", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson batchProgress(HttpServletRequest request, String batchId){
		AjaxJson aj = new AjaxJson("批量检测进度情况获取成功");
		aj.setSuccess(true);
		try {
			Map<String, Object> map = new HashMap<String, Object>();
			int succ = (int)EhcacheUtil.getItem("PRO_CK_PG_SUCC_" + batchId);
			int fail = (int)EhcacheUtil.getItem("PRO_CK_PG_FAIL_" + batchId);
			int stop = (int)EhcacheUtil.getItem("PRO_CK_PG_STOP_" + batchId);
			int count = (int)EhcacheUtil.getItem("PRO_CK_PG_ALL_" + batchId);
			int pg = ((succ + fail + stop)*100)/count;
			if(pg == 100){
				TaProcessCkRecordVo vo = (TaProcessCkRecordVo) EhcacheUtil.getItem("PRO_CK_" + batchId);
				List<TaProcessCheckDetail> ckDetails = vo.getCkPassDetails();
				for(String user : vo.getUsers()){
					for(TaProcessCheckDetail detail : ckDetails){
						if(user.equals(detail.getUserName())){
							logger.info( user + ":" + JsonUtil.toJson(detail));
						}
					}
				}
			}
			map.put("succ", succ);
			map.put("fail", fail);
			map.put("stop", stop);
			map.put("pg", pg);
			aj.setObj(map);
		} catch (Exception e) {
			aj.setSuccess(false);
			aj.setMsg("批量检测进度情况获取异常");
		}
		return aj;
	}
	
	/**
	 * 生成报告（批量）
	 * 
	 * @param request
	 * @param batchId
	 * @param resultRemark
	 * @return
	 */
	@RequestMapping(value = "saveBatchCk", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveBatchCk(HttpServletRequest request,String batchId, String resultRemark){
		AjaxJson aj = new AjaxJson("生成报告成功");
		aj.setSuccess(true);
		try {
			taProcessCheckService.saveBatchCk(batchId, resultRemark);
			EhcacheUtil.removeItem("PRO_CK_" + batchId);
			EhcacheUtil.removeItem("PRO_CK_PG_ALL_" + batchId);
			EhcacheUtil.removeItem("PRO_CK_PG_SUCC_" + batchId);
			EhcacheUtil.removeItem("PRO_CK_PG_FAIL_" + batchId);
			EhcacheUtil.removeItem("PRO_CK_PG_STOP_" + batchId);
		} catch (Exception e) {
			e.printStackTrace();
			aj.setSuccess(false);
			aj.setMsg("生成报告失败");
		}
		return aj;
	}
}
