package com.biz.eisp.activiti.designer.processcheck.service;

import java.util.HashMap;
import java.util.List;

import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckBatch;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckDetail;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckRecord;
import com.biz.eisp.activiti.designer.processcheck.vo.ProcCkQuerySetVo;
import com.biz.eisp.activiti.designer.processcheck.vo.TaProcessCkRecordVo;
import com.biz.eisp.base.core.service.BaseService;

/**
 * 流程检测业务接口.
 * <p>
 *
 * @author liukai
 * @version v1.0
 */
public interface TaProcessCheckService extends BaseService {

	public TaProcessCkRecordVo createProcessCheck(String processKey) throws Exception;
	
	public List<TaProcessCkRecordVo> getCkRecords(TaProcessCkRecordVo vo);
	
	public String saveRecord(String processId, String proCkQuerySet) throws Exception;
	
	public TaProcessCheckDetail passCkReq(TaProcessCheckDetail detail) throws Exception;
	
	public TaProcessCheckDetail findCheckDetail(String nodeCode, String recordId);
	
	public List<TaProcessCheckDetail> findCheckDetails(String recordId);
	
	public List<ProcCkQuerySetVo> checkQuerySet(String processId);
	
	public void updateCkRecord(TaProcessCheckRecord entity) throws Exception;
	
	public void deleteHis(String id) throws Exception;
	
	public TaProcessCkRecordVo findRecordDetail(String recordId) throws Exception;
	
	public HashMap<String, Object> getCkParams(String json) throws Exception;
	
	/**
	 * 获得检测用户
	 * 
	 * @param proCkQuerySet
	 * @return
	 * @throws Exception
	 */
	public List<String> getBatchUserIds(String proCkQuerySet) throws Exception;
	
	/**
	 * 生成报告（批量）
	 * @param batchId
	 * @param resultRemark
	 * @throws Exception
	 */
	public void saveBatchCk(String batchId, String resultRemark) throws Exception;
	
	public List<TaProcessCheckBatch> findCheckBatchs(String recordId);
}
