package com.biz.eisp.activiti.designer.processcheck.service.impl;

import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckBatch;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckDetail;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckRecord;
import com.biz.eisp.activiti.designer.processcheck.service.TaProcessCheckService;
import com.biz.eisp.activiti.designer.processcheck.util.ProcessCheckUtil;
import com.biz.eisp.activiti.designer.processcheck.vo.ProcCkQuerySetVo;
import com.biz.eisp.activiti.designer.processcheck.vo.TaProcessCkRecordVo;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.activiti.util.DateUtils;
import com.biz.eisp.activiti.util.EhcacheUtil;
import com.biz.eisp.activiti.util.JsonUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import org.activiti.bpmn.model.*;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * 流程检测业务接口实现.
 * <p>
 *
 * @author liukai
 * @version v1.0
 */
@Service("taProcessCheckService")
@Transactional
public class TaProcessCheckServiceImpl extends BaseServiceImpl implements TaProcessCheckService {
	@Autowired
	private RepositoryService repositoryService;
	@Autowired
	private IdentityService identityService;
	@Autowired
	private RuntimeService runtimeService;
	@Autowired
	private TaskService taskService;
	@Autowired
	private TmPositionService tmPositionService;
	@Autowired
	private TmUserService tmUserService;
	@Autowired
	private TaProcessNodeService taProcessNodeService;

	@Override
	public TaProcessCkRecordVo createProcessCheck(String processKey) throws Exception {
		TaProcessEntity process = this.findUniqueByProperty(TaProcessEntity.class, "processKey", processKey);
		TaProcessCkRecordVo vo = new TaProcessCkRecordVo();
		String processId = process.getId();
		vo.setProcessId(processId);
		vo.setState("0");
		vo.setIsBatchUser(0);
		vo.setTitle(process.getProcessName() + "_检测报告");
		List<TaProcessCheckDetail> ckPassDetails = new ArrayList<TaProcessCheckDetail>();
		// 发起
		TaProcessCheckDetail ckd = new TaProcessCheckDetail();
		ckd.setCheckType("PASS");
		ckd.setNodeName("发起");
		ckd.setNodeKey("TO_START");
		ckd.setState("0");
		ckPassDetails.add(ckd);
		Process proc = getActProcess(process.getProcessKey());
		Collection<FlowElement> flowElements = proc.getFlowElements();
		for(FlowElement flowElement : flowElements){
			if(flowElement instanceof UserTask){
				ckd = new TaProcessCheckDetail();
				ckd.setCheckType("PASS");
				ckd.setNodeName(flowElement.getName());
				ckd.setNodeKey(flowElement.getId());
				ckd.setState("0");
				ckPassDetails.add(ckd);
			}
		}
		vo.setCkPassDetails(ckPassDetails);
		EhcacheUtil.putItem("PRO_CK_" + processId, vo);
		delNoCkRecordAndDetails(processId, process.getProcessKey());
		return vo;
	}

	/**
	 * 删除未生成报告的记录
	 *
	 * @param processId
	 */
	private void delNoCkRecordAndDetails(String processId, String procKey){
		TaProcessCkRecordVo vo = new TaProcessCkRecordVo();
		vo.setProcessId(processId);
		vo.setState("0");
		List<TaProcessCkRecordVo> list = getCkRecords(vo);
		if(CollectionUtil.listNotEmptyNotSizeZero(list)) {
			for(TaProcessCkRecordVo t : list){
				deleteAllEntity(findCheckDetails(t.getId()));
				deleteEntityById(TaProcessCheckRecord.class, t.getId());
			}
		}
		// 删除垃圾任务
		List<Task> tasks = taskService.createTaskQuery().processDefinitionKey(procKey)
				.processVariableValueEquals("FROM_TYPE", ProcessCheckUtil.PROCESS_PASS_CHECK).list();
		for(Task task : tasks){
			this.executeSql("delete from act_ru_task where id_ = ?", task.getId());
		}
	}

	@Override
	public List<TaProcessCkRecordVo> getCkRecords(TaProcessCkRecordVo vo) {
		StringBuffer sb = new StringBuffer("select t.* from ta_process_check_record t where 1 = 1");
		List<Object> params = new ArrayList<Object>();
		if(StringUtils.isNotEmpty(vo.getProcessId())){
			sb.append(" and t.process_id = ?");
			params.add(vo.getProcessId());
		}
		if(StringUtils.isNotEmpty(vo.getState())){
			sb.append(" and t.state = ?");
			params.add(vo.getState());
		}
		sb.append(" order by t.check_time desc");
		return findBySql(TaProcessCkRecordVo.class, sb.toString(), params.toArray());
	}

	@Override
	public String saveRecord(String processId, String proCkQuerySet) throws Exception {
		TaProcessCkRecordVo vo = (TaProcessCkRecordVo) EhcacheUtil.getItem("PRO_CK_" + processId);
		TaProcessCheckRecord entity = new TaProcessCheckRecord();
		entity.setCheckTime(DateUtils.getFormatDateStr(new Date(), DateUtils.DEFAULT_DATE_ALL_PATTERN));
		entity.setProcessId(vo.getProcessId());
		entity.setState(vo.getState());
		entity.setTitle(vo.getTitle());
		entity.setIsBatchUser(vo.getIsBatchUser());
		entity.setCkParams(proCkQuerySet);
		save(entity);
		for(TaProcessCheckDetail detail : vo.getCkPassDetails()){
			detail.setRecordId(entity.getId());
			save(detail);
		}
		EhcacheUtil.removeItem("PRO_CK_" + processId);
		return entity.getId();
	}

	@Override
	public TaProcessCheckDetail passCkReq(TaProcessCheckDetail detail) throws Exception {
		if(detail != null){
			// 发起检测
			if(detail.getNodeKey().equals("TO_START")){
				detail = passStarPro(detail);
			}else{
				detail = passProNode(detail);
			}
		}else{
			throw new Exception("未找到该检测记录项");
		}
		return detail;
	}

	/**
	 * 流程节点通过检测
	 *
	 * @param detail
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("finally")
	private TaProcessCheckDetail passProNode(TaProcessCheckDetail detail) throws Exception{
		detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), DateUtils.DEFAULT_DATE_ALL_PATTERN));
		StringBuffer ckDetail = new StringBuffer();
		String oldCkResult = "";
		if(StringUtils.isNotEmpty(detail.getCheckResult())){
			oldCkResult = detail.getCheckResult();
		}
		try {
			TaProcessCheckRecord record = get(TaProcessCheckRecord.class, detail.getRecordId());
			if(record == null){
				throw new Exception("未找到检测记录");
			}
			TaProcessEntity process = get(TaProcessEntity.class, record.getProcessId());
			if(process == null){
				throw new Exception("未找到流程实体");
			}
			TaProcessCheckDetail startDetail = findCheckDetail("TO_START", record.getId());
			List<Task> tasks = taskService.createTaskQuery()
					.processInstanceId(startDetail.getProcessInsId())
					.taskDefinitionKey(detail.getNodeKey()).list();
			int taskSize = tasks.size();
			ckDetail.append("<p>检测出该节点产生了" + taskSize + "个任务</p>");
			int index = 1;
			for(Task task : tasks){
				ckDetail.append("<p>开始处理第" + index + "个任务...</p>");
				ckDetail = completeTask(task, ckDetail);
				ckDetail.append("<p>处理第" + index + "个任务结束...</p>");
				index ++;
			}
			detail.setState("1");
			detail.setProcessInsId(startDetail.getProcessInsId());
			detail.setCheckResult(oldCkResult + ckDetail.toString() + "<p>节点通过检测成功!</p>");
		} catch (Exception e) {
			e.printStackTrace();
			ckDetail.append("<p><span style=\"color:red\">节点通过检测失败!</span></p>");
			String msg = e.getMessage();
			if(StringUtils.isEmpty(msg)){
				msg = "未知错误，日志未被捕获。";
			}
//			else if(msg.length() > 2000){
//				msg = msg.substring(0, 2000) + "...";
//			}
			ckDetail.append("<p><span style=\"color:red\">错误日志：" + msg + "</span></p>");
			detail.setState("2");
			detail.setCheckResult(oldCkResult + ckDetail.toString());
		} finally {
			detail.setCheckResult(detail.getCheckResult() +
					"<p>-----------------------------------------</p>");
			return detail;
		}
	}

	/**
	 * 完成任务
	 *
	 * @param task
	 * @throws Exception
	 */
	private StringBuffer completeTask(Task task, StringBuffer ckDetail) throws Exception{
		boolean toComplete = true;
		String taskKey = task.getTaskDefinitionKey();
		String processKey = repositoryService.createProcessDefinitionQuery()
				.processDefinitionId(task.getProcessDefinitionId()).singleResult().getKey();
		TaProcessNodeProEntity node = taProcessNodeService.getTaProcessNodeByVersionKey(task.getProcessDefinitionId(),processKey);
		if(node == null){
			throw new RuntimeException("节点表中未找到该节点！");
		}
		Map<String, Object> variables = runtimeService.getVariables(task.getExecutionId());
		String proStartPosiCode = (String) variables.get(ProcessCheckUtil.PROCEE_START_POSICODE);
		// 发起人职位
		TmPositionVo vo = this.getPositionVoInfo(proStartPosiCode);
		// 当前审批人对应职位
		TmPositionVo currVo = null;
		if(task.getTaskDefinitionKey().equals(CommentUtil.DEFAULT_TASK_NODE)){//初始节点
			ckDetail.append("<p>任务处理人：[" + vo.getUserName() + "]" + vo.getFullName())
					.append("、职位[" + vo.getPositionCode() + "]" + vo.getPositionName() + "</p>");
		}else{
			if(StringUtils.isEmpty(task.getAssignee())){
				List <IdentityLink> identityLinkList = taskService.getIdentityLinksForTask(task.getId());
				if(CollectionUtil.listNotEmptyNotSizeZero(identityLinkList)) { //多个职位竞争审批的情况
					for(IdentityLink identityLink : identityLinkList) {
						if(StringUtils.isNotBlank(identityLink.getUserId())) {
							currVo = this.getPositionVoInfo(identityLink.getUserId());
							if(currVo == null){
								throw new RuntimeException("根据任务执行职位[" + task.getAssignee() + "]查询职位数据为空！");
							}
							ckDetail.append("<p>任务处理人：[" + currVo.getUserName() + "]" + currVo.getFullName())
									.append("、职位[" + currVo.getPositionCode() + "]" + currVo.getPositionName() + "</p>");
						}
					}
				} else {
					throw new RuntimeException("节点任务的[assignee]审批人字段为空！");
				}
			} else { //一个职位审批的情况
				currVo = this.getPositionVoInfo(task.getAssignee());
				if(currVo == null){
					throw new RuntimeException("根据任务执行职位[" + task.getAssignee() + "]查询职位数据为空！");
				}
				ckDetail.append("<p>任务处理人：[" + currVo.getUserName() + "]" + currVo.getFullName())
						.append("、职位[" + currVo.getPositionCode() + "]" + currVo.getPositionName() + "</p>");
			}
		}
		if (toComplete) {
			try{
				taskService.complete(task.getId());
			} catch (Exception e) {
				throw e;
			}
		}
		return ckDetail;
	}

	/**
	 * 流程通过发起检测
	 *
	 * @param detail
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("finally")
	private TaProcessCheckDetail passStarPro(TaProcessCheckDetail detail) throws Exception{
		detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), DateUtils.DEFAULT_DATE_ALL_PATTERN));
		TaProcessCheckRecord record = get(TaProcessCheckRecord.class, detail.getRecordId());
		if(record == null) throw new Exception("未找到检测记录");
		TaProcessEntity process = get(TaProcessEntity.class, record.getProcessId());
		if(process == null) throw new Exception("未找到流程实体");
		String authenticatedUser = "";
		StringBuffer ckDetail = new StringBuffer();
		try {
			Map<String, Object> variables = getCkParams(record.getCkParams());
			variables.put("FROM_TYPE", "PROCESS_PASS_CHECK");
			// 设置流程发起人
			authenticatedUser = (String)variables.get(ProcessCheckUtil.PROCEE_START_USERNAME);
			if(StringUtils.isEmpty(authenticatedUser)){
				authenticatedUser = "admin";
				variables.put(ProcessCheckUtil.PROCEE_START_USERNAME, "admin");
				ckDetail.append("<p>未设置发起人账号，默认采用[" + authenticatedUser + "]去执行流程发起；</p>");
			}else{
				ckDetail.append("<p>采用设置的发起人账号[" + authenticatedUser + "]去执行流程发起；</p>");
			}
			// 设置发起人职位参数
			TmUserVo user = this.getUserVo(authenticatedUser);
			if(user == null){
				ckDetail.append("<p><span style=\"color:red\">根据发起人账号[" + authenticatedUser + "]未找到对应用户;</span></p>");
				throw new Exception("");
			}
			TmPositionVo vo = this.getPositionVoById(user.getPositionId());
			if(vo == null){
				ckDetail.append("<p><span style=\"color:red\">未找到发起人对应职位;</span></p>");
				throw new Exception("");
			}else{
				ckDetail.append("<p>发起人信息：[" + authenticatedUser + "]" + user.getFullName())
						.append("，职位[" + vo.getPositionCode() + "]" + vo.getPositionName() + "；</p>");
			}
			variables.put(ProcessCheckUtil.PROCEE_START_POSICODE, vo.getPositionCode());

			identityService.setAuthenticatedUserId(authenticatedUser);
			String bussId = UUID.randomUUID().toString().replace("-", "");
			ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(
					process.getProcessKey(), bussId, variables);
			ckDetail.append("<p>成功发起了流程，发起检测成功!</p>");
			detail.setState("1");
			detail.setProcessInsId(processInstance.getProcessInstanceId());
			detail.setCheckResult(ckDetail.toString());
		} catch (Exception e) {
			ckDetail.append("<p><span style=\"color:red\">发起流程失败!</span></p>");
			String msg = e.getMessage();
			if(StringUtils.isEmpty(msg)){
				msg = "未知错误，日志未被捕获。";
			}else if(msg.length() > 500){
				msg = msg.substring(0, 500) + "...";
			}
			ckDetail.append("<p><span style=\"color:red\">错误日志：" + msg + "</span></p>");
			detail.setState("2");
			detail.setCheckResult(ckDetail.toString());
		} finally {
			detail.setCheckResult(detail.getCheckResult() +
					"<p>-----------------------------------------</p>");
			return detail;
		}
	}

	@Override
	public HashMap<String, Object> getCkParams(String json) throws Exception {
		HashMap<String, Object> result = new HashMap<String, Object>();
		if(StringUtils.isNotEmpty(json)){
			@SuppressWarnings("unchecked")
			HashMap<String, String> jsonMap = (HashMap<String, String>)
					JsonUtil.jsonToObject(json, Object.class);
			for (Map.Entry<String, String> entry : jsonMap.entrySet()) {
				if(ProcessCheckUtil.PROCEE_START_USERNAME.equals(entry.getKey())){// 发起人
					result.put(ProcessCheckUtil.PROCEE_START_USERNAME, entry.getValue());
				}else if("title".equals(entry.getKey())){// 标题
					result.put("title", entry.getValue());
				}else if("isBatchUser".equals(entry.getKey())){// 是否为批量
					result.put("isBatchUser", entry.getValue());
				}else if("paramName".equals(entry.getKey()) && StringUtils.isNotBlank(entry.getValue())){// 默认参数
					String paramValue = jsonMap.get("paramValue");
					if(paramValue.equals("true") || paramValue.equals("false")){
						result.put(entry.getValue(), Boolean.parseBoolean(paramValue));
					}else{
						result.put(entry.getValue(), paramValue);
					}
				}else if(entry.getKey().contains("paramName") && StringUtils.isNotBlank(entry.getValue())){// 其它参数
					String index = entry.getKey().replace("paramName", "");
					String paramValue = jsonMap.get("paramValue" + index);
					if(paramValue.equals("true") || paramValue.equals("false")){
						result.put(entry.getValue(), Boolean.parseBoolean(paramValue));
					}else{
						result.put(entry.getValue(), paramValue);
					}
				}
			}
		}

		return result;
	}

	@Override
	public TaProcessCheckDetail findCheckDetail(String nodeCode, String recordId) {
		List<TaProcessCheckDetail> list = findBySql(TaProcessCheckDetail.class,
				"select * from ta_process_check_detail where node_key = ? and record_id = ?",
				new Object[]{nodeCode, recordId});
		if(list.size() > 0){
			return list.get(0);
		}
		return null;
	}

	@Override
	public List<TaProcessCheckDetail> findCheckDetails(String recordId) {
		return findBySql(TaProcessCheckDetail.class,
				"select * from ta_process_check_detail where record_id = ?",
				new Object[]{recordId});
	}

	@Override
	public List<TaProcessCheckBatch> findCheckBatchs(String recordId) {
		return findBySql(TaProcessCheckBatch.class,
				"select * from ta_process_check_batch where record_id = ?",
				new Object[]{recordId});
	}

	/**
	 * 根据流程key获得流程对象
	 *
	 * @param processKey
	 * @return
	 */
	private Process getActProcess(String processKey){
		ProcessDefinition pf = repositoryService.createProcessDefinitionQuery().
				processDefinitionKey(processKey).latestVersion().singleResult();
		BpmnModel bpmnModel = repositoryService.getBpmnModel(pf.getId());
		return bpmnModel.getProcesses().get(0);
	}

	@Override
	public List<ProcCkQuerySetVo> checkQuerySet(String processId) {
		List<ProcCkQuerySetVo> params = new ArrayList<ProcCkQuerySetVo>();
		TaProcessEntity proc = get(TaProcessEntity.class, processId);
		Process process = getActProcess(proc.getProcessKey());
		Collection<FlowElement> flowElements = process.getFlowElements();
		for(FlowElement flowElement : flowElements){
			if(flowElement instanceof SequenceFlow){
				SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
				String condition = sequenceFlow.getConditionExpression();
				if(StringUtils.isNotEmpty(condition)){
					params.add(new ProcCkQuerySetVo(condition, "", sequenceFlow.getName(), "1"));
				}
			}
		}
		return params;
	}

	@Override
	public void updateCkRecord(TaProcessCheckRecord entity) throws Exception {
		TaProcessCheckRecord oldEntity = get(TaProcessCheckRecord.class, entity.getId());
		if(oldEntity != null){
			oldEntity.setTitle(entity.getTitle());
			oldEntity.setCkParams(entity.getCkParams());
			oldEntity.setState(entity.getState());
			oldEntity.setResultRemark(entity.getResultRemark());
			updateEntity(oldEntity);
		}
	}

	@Override
	public void deleteHis(String id) throws Exception {
		deleteEntityById(TaProcessCheckRecord.class, id);
		deleteAllEntity(findCheckDetails(id));
		deleteAllEntity(findCheckBatchs(id));
	}

	@Override
	public TaProcessCkRecordVo findRecordDetail(String recordId) throws Exception {
		List<TaProcessCkRecordVo> list = this.findBySql(TaProcessCkRecordVo.class,
				"select * from ta_process_check_record where id = ? ", new Object[]{recordId});
		if(list.size() > 0){
			TaProcessCkRecordVo vo = list.get(0);
			vo.setCkParamMap(getCkParams(vo.getCkParams()));
			vo.setRealParams(checkQuerySet(vo.getProcessId()));
			vo.setCkPassDetails(findCheckDetails(recordId));
			vo.setBatchDetails(findCheckBatchs(recordId));
			return vo;
		}
		return null;
	}

	@Override
	public List<String> getBatchUserIds(String proCkQuerySet) throws Exception {
		List<String> list = new ArrayList<String>();
		HashMap<String, Object> map = getCkParams(proCkQuerySet);
		String strUsers = (String) map.get(ProcessCheckUtil.PROCEE_START_USERNAME);
		if(StringUtils.isBlank(strUsers)){
			throw new Exception("用户参数为空");
		}
		String[] users = strUsers.split(",");
		for(String user : users){
			if(StringUtils.isNotBlank(user) && !list.contains(user)){
				list.add(user);
			}
		}
		if(list.size() == 0){
			throw new Exception("检测用户为空");
		}
		return list;
	}

	@Override
	public void saveBatchCk(String batchId, String resultRemark) throws Exception {
		TaProcessCkRecordVo vo = (TaProcessCkRecordVo) EhcacheUtil.getItem("PRO_CK_" + batchId);
		TaProcessCheckRecord entity = new TaProcessCheckRecord();
		entity.setCheckTime(vo.getCheckTime());
		entity.setProcessId(vo.getProcessId());
		entity.setState("1");
		int fail = (int)EhcacheUtil.getItem("PRO_CK_PG_FAIL_" + batchId);
		if(fail > 0){
			entity.setState("2");
		}
		entity.setTitle(vo.getTitle() + "(批量)");
		entity.setIsBatchUser(vo.getIsBatchUser());
		entity.setCkParams(vo.getCkParams());
		entity.setResultRemark(resultRemark);
		save(entity);
		List<TaProcessCheckDetail> ckDetails = vo.getCkPassDetails();
		for(String user : vo.getUsers()){
			TaProcessCheckBatch batch = new TaProcessCheckBatch();
			batch.setRecordId(entity.getId());
			batch.setUserName(user);
			List<TaProcessCheckDetail> details = new ArrayList<TaProcessCheckDetail>();
			for(TaProcessCheckDetail detail : ckDetails){
				if(user.equals(detail.getUserName())){
					detail.setRecordId(entity.getId());
					details.add(detail);
				}
			}
			batch.setJsonData(JsonUtil.toJson(details));
			save(batch);
		}
	}

	/**
	 * 获取职位信息
	 * @param positionCode
	 * @return
	 */
	private TmPositionVo getPositionVoInfo(String positionCode) {
		if(StringUtils.isBlank(positionCode)) {
			throw new RuntimeException("未传递职位编码信息");
		}
		TmPositionVo paramVo = new TmPositionVo();
		paramVo.setPositionCode(positionCode);
		List <TmPositionVo> list = tmPositionService.findPositionByConditions(paramVo, null);
		if(CollectionUtil.listNotEmptyNotSizeZero(list)) {
			return list.get(0);
		}
		return null;
	}

	/**
	 * 通过id获取职位信息
	 * @param id
	 * @return
	 */
	private TmPositionVo getPositionVoById(String id) {
		TmPositionEntity positionEntity = tmPositionService.get(TmPositionEntity.class, id);
		if(positionEntity == null) {
			return null;
		}
		return this.getPositionVoInfo(positionEntity.getPositionCode());
	}

	private TmUserVo getUserVo(String userName) {
		TmUserVo paramVo = new TmUserVo();
		paramVo.setUserName(userName);
		TmUserVo userVo = tmUserService.getTmUser(paramVo);
		return userVo;
	}


}
