package com.biz.eisp.activiti.designer.processconf.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.mdm.web.pojo.Client;
import org.activiti.engine.RepositoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.designer.processconf.entity.TaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaRoleService;
import com.biz.eisp.activiti.designer.processconf.vo.TaActRoleVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.activiti.runtime.service.TaDeploymentService;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.actrole.entity.TmActRoleEntity;
import com.biz.eisp.mdm.actrole.transformer.TmActRoleEntityToTmActRoleVo;
import com.biz.eisp.mdm.actrole.vo.TmActRoleVo;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;



/**
 * 工作流角色控制器
 * @author wan
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@Controller
@RequestMapping("/taActivitiRoleController")
public class TaActivitiRoleController extends BaseController{
	@Autowired
	private TaRoleService taRoleService;
	@Autowired(required = false)
	private RepositoryService repositoryService;
	@Autowired
	private TaDeploymentService taDeploymentService;
	/**
	 * 跳转到Role主页面
	 * @author wan
	 * @return ModelAndView
	 */
	@RequestMapping(value = "goTaActivitiRoleMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaActivitiRoleMain(){
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiRoleMain");
	}
	
	/**
	 * 跳转到Role的form界面
	 * @author wan
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goTaActivitiRoleForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaActivitiRoleForm(HttpServletRequest request){
		String id = OConvertUtils.getString(request.getParameter("id"));
		if(StringUtil.isNotEmpty(id)){
			TaActRoleEntity roleEntity = taRoleService.get(TaActRoleEntity.class, id);
			request.setAttribute("role", roleEntity);
		} else {
			TaActRoleEntity roleEntity = new TaActRoleEntity();
			roleEntity.setRoleCode("BPM_");
			request.setAttribute("role", roleEntity);
		}
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiRoleForm");
	}
	
	/**
	 * 查询所有的role 
	 * @author wan
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "findActRoleList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findActRoleList(TaActRoleVo taActRoleVo,HttpServletRequest request,HttpServletResponse response){
		Page page = new EuPage(request);
		List<TaActRoleVo> roles = taRoleService.findActRoleList(taActRoleVo, page);
		return new DataGrid(roles, page);
	}
	
	/**
	 * 查询所有的role 
	 * @author wan
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "findTaActivitiRoleList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public void findTpUserList(TaActRoleVo taActRoleVo,HttpServletRequest request,HttpServletResponse response){
		//获取当前职位
		String posId = ResourceConfigUtils.getString("position");
		Client client= ResourceConfigUtils.getClient();
		//获取当前用户
		TmUserEntity tmUserEntity = client.getUser();
		
		Page page = new EuPage(request);
		if(StringUtil.isNotEmpty(tmUserEntity)&& Globals.Admin_Name.equalsIgnoreCase(tmUserEntity.getUserName())){
			taActRoleVo.setPosId(null);
		}else{
			taActRoleVo.setPosId(posId);
		}
		//获取角色 并返回
		List<TaActRoleEntity> roles = taRoleService.getRoleListByCurrentPosId(taActRoleVo, page);
		this.datagridReturn(response, roles, page);
	}
	
	/**
	 * 保存或者更新role
	 * @author wan
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "saveOrUpdateTaActivitiRole", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateTpUser(HttpServletRequest request, TaActRoleVo taActRoleVo){
		AjaxJson j = new AjaxJson();
		try {
			Page page = new EuPage(request);
			taRoleService.createTmRole(taActRoleVo, page);
		} catch (Exception e) {
			j.setSuccess(false);
			j.setMsg(e.getMessage());
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 删除role
	 * @author wan
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "deleteTaActivitiRoleById", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTpUserById(String id){
		AjaxJson j = new AjaxJson();
		try {
			if(taRoleService.deleteTmRole(id)){
				j.setMsg("删除角色成功");
			}else{
				j.setSuccess(false);
				j.setMsg("超级管理员角色不能被删除");
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return j;
	}
	/**
	 * 检查角色名称.
	 * @author grover
	 * @param tmRoleEntity 角色
	 * @return
	 */
    @RequestMapping(value = "validFormRoleForm", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validFormRoleForm(HttpServletRequest request,TaActRoleEntity tmRoleEntity) {
    	String param = OConvertUtils.getString(request.getParameter("param"));
    	String flag = OConvertUtils.getString(request.getParameter("flag"));
    	if(StringUtil.isNotEmpty(flag) && flag.equalsIgnoreCase("roleName")){
    		tmRoleEntity.setRoleName(param);
    	}
    	if(StringUtil.isNotEmpty(flag) && flag.equalsIgnoreCase("roleCode")){
    		tmRoleEntity.setRoleCode(param);
    	}
        return taRoleService.validateTmRoleForm(tmRoleEntity);
    }
	/**
	 * 跳转角色相关职位.
	 * <p>跳转角色相关职位的主页面
	 * @param request 请求对象
	 * @return 职位管理页面路径
	 */
	@RequestMapping(value = "goTmPositionByRoleMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTmPositionByRoleMain(String roleCode, HttpServletRequest request) {
		if(StringUtil.isNotEmpty(roleCode)){
			request.setAttribute("roleCode", roleCode);
		}
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiRolePositionMain");
	}
	
	
	
	/**
	 * 工作流角色，查看相关的职位
	 * 	1:在工作流角色界面，点击相关流程，进入该界面，由dataGrid请求，查询相关的职位
	 * @param roleCode
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "findPositionByActRoleCode", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findPositionByActRoleCode(TmPositionVo tmPositionVo, String roleCode,HttpServletRequest request){
		Page page = new EuPage(request);
		List<TmPositionVo> result = taRoleService.findPositionByRoleCode(tmPositionVo, roleCode,page);
		return new DataGrid(result, page);
	}
	
	
	
	
	/**
	 * 跳转到查看流程主页面
	 * @author wan
	 * @return
	 */
	@RequestMapping(value = "goTaProcessDefinitionMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessDefinitionMain(TmActRoleVo tmRoleVo){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiProcessDefinitionMain");
		TmActRoleEntity tmRoleEntity = taRoleService.get(TmActRoleEntity.class, tmRoleVo.getId());
		tmRoleVo = new TmActRoleEntityToTmActRoleVo().apply(tmRoleEntity);
		
		view.addObject("roleCode", tmRoleVo.getRoleCode());
		view.addObject("pdId", tmRoleVo.getId());
		return view;
	}
	/**
	 * 查看相关的流程
	 * @author wan
	 * @return
	 */
	@RequestMapping(value = "findTaProcessDefinitionMain", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTaProcessDefinitionMain(TaProcessVo taProcessVo, String roleCode,HttpServletRequest request,HttpServletResponse response){
		Page page = new EuPage(request);
		List <TaProcessVo> list = taDeploymentService.findTaProcessVoList(taProcessVo, roleCode, page);
		return new DataGrid(list, page);
	}
	
	/**
	 * 流程定义页面，到看流程图
	 * @author wan
	 * @return
	 */
	@RequestMapping(value = "goShowProcessDefinitionImage", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goShowProcessDefinitionImage(String proId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiProcessDefinitionImage");
		view.addObject("proId", proId);
		return view;
	}
	/**
	 * 查看流程定义详情
	 * @author wan
	 */
	@RequestMapping(value = "findProcessDefinitionImage", method = {RequestMethod.GET, RequestMethod.POST})
	public void findProcessDefinitionImage(String proId,HttpServletResponse response){
		response.setContentType("image/jpeg");
		InputStream is = null;
		OutputStream os = null;
		try {
			is = repositoryService.getProcessDiagram(proId);//输入流程定义的id，查询图片
			os = response.getOutputStream();
			int len = 0;
			byte[] b = new byte[1024];
			while ((len = is.read(b, 0, 1024)) != -1) {
	            response.getOutputStream().write(b, 0, len);
	        }
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			try {
				os.close();
				is.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	
}
