package com.biz.eisp.activiti.designer.processconf.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.entity.TaListenerEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaListenerService;
import com.biz.eisp.activiti.designer.processconf.vo.TaListenerVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;

/**
 * 监听器管理Controller.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taListenerController")
public class TaListenerController extends BaseController{
	@Autowired
	private TaListenerService taListenerService;
	
	/**
	 * 跳转到监听器的主页面
	 * @author wan
	 * @return ModelAndView
	 */
	@RequestMapping(value = "goTaListenerMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaListenerMain() {
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taListenerMain");
	}
	/**
	 * 跳转到监听器的Form页面
	 * @author wan
	 * @return ModelAndView
	 */
	@RequestMapping(value = "goTaListenerForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaListenerForm(TaListenerVo taListenerVo,HttpServletRequest request,
			HttpServletResponse response) {
		if(StringUtils.isNotBlank(taListenerVo.getId())) {
			TaListenerVo vo = taListenerService.getTaListener(taListenerVo, page);
			request.setAttribute("vo", vo);
		}
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taListenerForm");
	}
	
	/**
	 * 跳转到ListenerListPage页面
	 * @author wan   从taProcessPropertiesForm有跳转过来
	 * @return
	 */
	@RequestMapping(value = "goListenerListPage", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goListenerListPage(String typeId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/listenerList");
		view.addObject("typeId", typeId);
		return view;
	}
	/**
	 * 获得自定义监听列表
	 * 从编辑页面，选择监听的方法
	 * @author wan
	 * @return
	 */
	@RequestMapping(value = "findTaListenerGird", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTaListenerGrid(HttpServletRequest request,TaListenerVo taListenerVo){
		String pageStr = request.getParameter("page");
		if(StringUtils.isNotBlank(pageStr)) {
			page = new EuPage(request);
		} else {
			page = null;
		}
		List<TaListenerVo> voList = taListenerService.findTaListenerList(taListenerVo, page);
		return new DataGrid(voList, page);
	}
	
	/**
	 * 获取节点已设置的监听器
	 * @author wan
	 * @param tpProcessListenerVo
	 * @param request
	 * @param response
	 * @return DataGrid
	 */
	@RequestMapping(value = "findSelectedListenerList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findSelectedListenerList(String ids, HttpServletRequest request,
				HttpServletResponse response) {
		Page page = new EuPage(request);
		List <TaListenerVo> voList = taListenerService.findTaListenerList(ids, page);
		return new DataGrid(voList, page);
	}
	
	/**
	 * 保存监听
	 * @author wan
	 * @param tpProcessListenerVo
	 * @param request
	 * @param response
	 * @return AjaxJson
	 */
	@RequestMapping(value = "saveTaListener", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveTaListener(TaListenerVo taListenerVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		taListenerService.saveTaListener(taListenerVo, page);
		return new AjaxJson();
	}
	
	/**
	 * 删除监听器
	 * 
	 * @return
	 */
	@RequestMapping(value = "delListeren", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delListeren(TaListenerVo taListenerVo, HttpServletRequest request) {
		AjaxJson j = new AjaxJson();
		TaListenerEntity te = taListenerService.get(TaListenerEntity.class, taListenerVo.getId());
		if (te.getTaRProcessNodeListenerEntityList().size() == 0) {
			message = "监听: " + te.getListenerName() + " 删除成功";
			taListenerService.delete(te);
		} else {
			message = "监听: " + te.getListenerName() + "已经在运行中无法删除";
		}
		j.setMsg(message);
		return j;
	}
	/**
	 * 禁用,启用流程监听
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "setTaListenerState", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson setTaListenerState(TaListenerVo taListenerVo) {
		AjaxJson j = new AjaxJson();
		String id = taListenerVo.getId();
		TaListenerEntity te = taListenerService.get(TaListenerEntity.class, id);
		if (te != null) {
			Short state = (WorkFlowGlobals.LISTENER_YES.equals(te.getListenerState())) ? WorkFlowGlobals.LISTENER_NO : WorkFlowGlobals.LISTENER_YES;
			te.setListenerState(state);
			taListenerService.updateEntity(te);
			if (state.equals(WorkFlowGlobals.LISTENER_NO)) {
				j.setMsg("监听已禁用");
			} else {
				j.setMsg("监听已启用");
			}
		}
		return j;
	}
	/**
	 * 验证监听名称是否已经存在
	 * @author wuzhujun
	 * @param taListenerVo 事件监听vo
	 * @param request 请求对象
	 * @return
	 */
	@RequestMapping(value = "validateName", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public ValidForm validateName(TaListenerVo taListenerVo,HttpServletRequest request) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		if(StringUtil.isNotEmpty(taListenerVo.getId())){
			//修改
			Criterion cr1 = Restrictions.eq("listenerName",param);
			Criterion cr2 = Restrictions.ne("id", taListenerVo.getId());
			List<TaListenerEntity> taListeners = taListenerService.findByCriteria(TaListenerEntity.class, cr1, cr2);
			if(!CollectionUtils.isEmpty(taListeners)){
				validForm.setStatus("n");
				validForm.setInfo("监听名称已存在");
			}
		}else{
			//新增
			Criterion cr3 = Restrictions.eq("listenerName", param);
			List<TaListenerEntity> taListeners  = taListenerService.findByCriteria(TaListenerEntity.class, cr3);
			if(!CollectionUtils.isEmpty(taListeners)){
				validForm.setStatus("n");
				validForm.setInfo("监听名称已存在");
			}
		}
		return validForm;
	}
}
