package com.biz.eisp.activiti.designer.processconf.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.StreamUtils;

/**
 * 工作流设计管理Controller.
 * <p>
 * 主要对工作流的设计信息进行CURD操作
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taProcessController")
public class TaProcessController extends BaseController{

	@Autowired
	private TaProcessService taProcessService;
	
	/**
	 * 流程列表
	 * 
	 * @return
	 */
	@RequestMapping(value = "goTaProcessMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessMain(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessMain");
	}
	
	/**
	 * 流程设计主页面跳转
	 * <p>
	 * 从页面得按钮 新建流程，这个controller
	 * 
	 * @return
	 */
	@RequestMapping(value = "goTaProcessForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessForm(HttpServletRequest request) {
		String processid = OConvertUtils.getString(request.getParameter("id"), "0");
		request.setAttribute("processid", processid);// 流程ID
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessForm");
	}
	
	@RequestMapping(value = "processTabs", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView processTabs(String id) {
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessTabs");
		view.addObject("taProcessId", id);
		return view;
	}
	
	/**
	 * 到业务实体选择页面
	 * @author wan
	 * @return
	 */
	@RequestMapping(value = "goTaProcessSelect", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessSelect(){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessSelect");
		return view;
	}
	
	
	/**
	 * 流程设计主页面属性值页面跳转
	 * <p>
	 * 从页面得按钮 新建流程，这个controller
	 * 这个是流程定义的属性
	 * @return
	 */
	@RequestMapping(value = "goTaProcessPropertiesForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessPropertiesForm(HttpServletRequest request) {
		String id = OConvertUtils.getString(request.getParameter("id"));// 流程当前节点Id
		String checkbox = OConvertUtils.getString(request.getParameter("checkbox"));// 设置单选多选
		String processId = OConvertUtils.getString(request.getParameter("processId"));// 流程key
		String processDefinitionId = OConvertUtils.getString(request.getParameter("processDefinitionId"));
		TaProcessEntity taProcessEntity = taProcessService.findUniqueByProperty(TaProcessEntity.class, "id", processDefinitionId);
		
		if (taProcessEntity != null) {
			request.setAttribute("processDefinitionId", taProcessEntity.getId());
			processId = taProcessEntity.getProcessKey();
			request.setAttribute("listenerClass", taProcessEntity.getListenerClass());
			request.setAttribute("tableName", taProcessEntity.getTableName());
			request.setAttribute("redirectUrl", taProcessEntity.getRedirectUrl());
		}
		request.setAttribute("checkbox", checkbox);
		request.setAttribute("id", id);
		request.setAttribute("processId", processId);
		request.setAttribute("key", processId);
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessPropertiesForm");
	}
	
	@RequestMapping(value = "findProcessList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findProcessList(TaProcessVo taProcessVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		List <TaProcessVo> list = taProcessService.findTaProcessList(taProcessVo, page);
		return new DataGrid(list, page);
	}
	
	/**
	 * 保存/编辑 流程
	 * @author wan
	 * @param taProcessVo
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "saveTaProcess", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveTaProcess(TaProcessVo taProcessVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		
		taProcessVo.setId(request.getParameter("processDefinitionId"));
		taProcessVo.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_NO); //未发布状态
		
		taProcessService.saveTaProcess(taProcessVo, page);

		return new AjaxJson();
	}
	
	@RequestMapping(value = "deleteTaProcess", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTaProcess(TaProcessVo taProcessVo, 
			HttpServletRequest request, HttpServletResponse response) {
		taProcessService.deleteTaProcess(taProcessVo, page);
		return new AjaxJson();
	}
	
	/**
	 * 流程编辑
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "getProcessXml", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public void getProcessXml(HttpServletRequest request, HttpServletResponse response) {
		response.setContentType("text/xml;charset=UTF-8");
		String processId = OConvertUtils.getString(request.getParameter("processId"));
		TaProcessEntity tProcess = taProcessService.get(TaProcessEntity.class, processId);
		String retstr;
		try {
			retstr = StreamUtils.InputStreamTOString(StreamUtils.byteTOInputStream(tProcess.getProcessXml()));
			response.getWriter().write(retstr);
		} catch (Exception e1) {
			e1.printStackTrace();
		}
	}
}
