package com.biz.eisp.activiti.designer.processconf.controller;

import java.io.InputStream;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.activiti.engine.RepositoryService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessDefinitionService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessDefinitionVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.web.BaseController;

/**
 * 流程定义，流程版本管理.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taProcessDefinitionController")
public class TaProcessDefinitionController extends BaseController {

	@Autowired
	private TaProcessDefinitionService taProcessDefinitionService;
	@Autowired(required = false)
	private RepositoryService repositoryService;

	/**
	 * 跳转至流程部署版本页面.
	 * <p>
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goProcessDefinitionMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView deploymentListByProcesskey(String processKey, HttpServletRequest request) {
		if (StringUtils.isEmpty(processKey)) {
			throw new BusinessException("未找到流程定义Key");
		}
		request.setAttribute("processKey", processKey);
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/processdefinition/processDefinitionMain");
	}

	/**
	 * 查询流程定义Vo对象列表.
	 * <p>
	 * 
	 * @param taProcessDefinitionVo
	 *            流程定义Vo对象，传递processDefinitionKey
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "findProcessDefinitionList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findProcessDefinitionList(TaProcessDefinitionVo taProcessDefinitionVo, HttpServletRequest request,
			HttpServletResponse response) {
		List<TaProcessDefinitionVo> voList = taProcessDefinitionService.findProcessDefinitionList(taProcessDefinitionVo,
				null);
		return new DataGrid(voList, null);
	}

	/**
	 * 挂起激活流程.
	 * <p>
	 * 
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "setProcessState", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson setProcessState(String state, String processDefinitionId, HttpServletRequest request) {
		if (state.equals("active")) {
			repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
			return new AjaxJson("流程已激活");
		} else {
			repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
			return new AjaxJson("流程已挂起");
		}
	}

	/**
	 * 跳转到流程定义图片信息页面.
	 * <p>
	 * 
	 * @param diagramResourceName 图片资源名称
	 * @param deploymentId 部署ID
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goProcessDefinitionPicInfoForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goProcessDefinitionPicInfoForm(String diagramResourceName, String deploymentId,
			HttpServletRequest request) {
		request.setAttribute("diagramResourceName", diagramResourceName);
		request.setAttribute("deploymentId", deploymentId);

		return new ModelAndView(
				"com/biz/eisp/activiti/designer/processconf/processdefinition/processDefinitionPicInfoForm");
	}

	/**
	 * 获取图片资源.
	 * <p>
	 * @param diagramResourceName 图片资源名称
	 * @param deploymentId 部署ID
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping(value = "getProcessDefinitionPicInfo", method = {RequestMethod.GET, RequestMethod.POST})
	public void getProcessDefinitionPicInfo(String diagramResourceName, String deploymentId, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try {
			InputStream resourceAsStream = repositoryService.getResourceAsStream(deploymentId, diagramResourceName);
			byte[] b = new byte[1024];
			int len = -1;
			while ((len = resourceAsStream.read(b, 0, 1024)) != -1) {
				response.getOutputStream().write(b, 0, len);
			}
			response.getOutputStream().flush();
			response.getOutputStream().close();
		} catch(Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * 删除流程定义.
	 * <p>
	 * 
	 * @param taProcessDefinitionVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "deleteProcessDefinition", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteProcessDefinition(TaProcessDefinitionVo taProcessDefinitionVo, HttpServletRequest request) {
		try {
			taProcessDefinitionService.deleteProcessDefinition(taProcessDefinitionVo);
		} catch (Exception e) {
			e.printStackTrace();
			return new AjaxJson(e.getMessage());
		}
		return new AjaxJson();
	}
}
