package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessFunctionAuthService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessFunctionAuthVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * Created by liukai on 2018/1/15.
 * 菜单中可以选取的流程配置 Controller
 */
@Controller
@RequestMapping("/taProcessFunctionAuthController")
public class TaProcessFunctionAuthController extends BaseController {

    @Autowired
    private TaProcessFunctionAuthService taProcessFunctionAuthService;

    /**
     * 跳转配置主页面
     *
     * @return ModelAndView
     */
    @RequestMapping(value = "goTaProcessFunctionAuthMain", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaProcessFunctionAuthMain() {
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessFunctionAuthMain");
    }

    /**
     * 跳转到配置的Form页面
     *
     * @return ModelAndView
     * @author wan
     */
    @RequestMapping(value = "goTaProcessFunctionAuthForm", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaProcessFunctionAuthForm(TaProcessFunctionAuthVo taProcessFunctionAuthVo, HttpServletRequest request,
                                                    HttpServletResponse response) {
        if (StringUtils.isNotBlank(taProcessFunctionAuthVo.getId())) {
            TaProcessFunctionAuthVo vo = taProcessFunctionAuthService.getTaProcessFunctionAuthVo(taProcessFunctionAuthVo.getId());
            request.setAttribute("vo", vo);
        }
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessFunctionAuthForm");
    }

    /**
     * 获取配置列表信息
     *
     * @param request
     * @param taProcessFunctionAuthVo
     * @return
     */
    @RequestMapping(value = "findTaProcessFunctionAuthVoList", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findTaProcessFunctionAuthVoList(HttpServletRequest request,
                                                    TaProcessFunctionAuthVo taProcessFunctionAuthVo) {
        Page page = new EuPage(request);
        List<TaProcessFunctionAuthVo> voList = taProcessFunctionAuthService.findTaProcessFunctionAuthVoList(taProcessFunctionAuthVo, page);
        return new DataGrid(voList, page);
    }

    /**
     * 保存配置信息
     *
     * @param taProcessFunctionAuthVo
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "saveTaProcessFunctionAuth", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveTaProcessFunctionAuth(TaProcessFunctionAuthVo taProcessFunctionAuthVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson aj = new AjaxJson();
        try {
            ValidForm validForm = taProcessFunctionAuthService.saveTaProcessFunctionAuth(taProcessFunctionAuthVo);
            if ("Y".equals(validForm.getStatus())) {
                aj.setSuccess(true);
                aj.setMsg("保存成功");
            } else {
                aj.setSuccess(false);
                aj.setMsg(validForm.getInfo());
            }
        } catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg("保存失败：" + e.getMessage());
        }
        return aj;
    }

    /**
     * 删除配置
     *
     * @return
     */
    @RequestMapping(value = "deleteTaProcessFunctionAuth", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteTaProcessFunctionAuth(String ids, HttpServletRequest request) {
        AjaxJson aj = new AjaxJson();
        aj.setSuccess(true);
        try {
            String [] idsArr = ids.split(",");
            for(String id : idsArr) {
                ValidForm validForm = taProcessFunctionAuthService.deleteTaProcessFunctionAuthVo(id);
                if ("Y".equals(validForm.getStatus())) {
                    aj.setMsg("删除成功");
                } else {
                    aj.setMsg(validForm.getInfo());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg("删除失败：" + e.getMessage());
        }
        return aj;
    }
}
