package com.biz.eisp.activiti.designer.processconf.controller;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeAuthService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeAuthVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.dict.util.DictUtil;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 工作流设计节点元素权限管理 Controller.
 * <p>
 * 主要对工作流的设计节点元素按钮权限信息进行CURD操作
 *
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taProcessNodeAuthController")
public class TaProcessNodeAuthController extends BaseController {

    @Autowired
    private TaProcessNodeAuthService taProcessNodeAuthService;

    /**
     * 跳转到流程节点主页面
     *
     * @param taProcessId 流程Id
     * @return
     * @author wan
     */
    @RequestMapping(value = "goTaProcessNodeAuthMain", method = {RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaProcessNodeMain(String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessNodeAuthMain");
        List <TmDictDataVo> btnList =  DictUtil.getDictList("tm_process_node_auth");
        view.addObject("taProcessId", taProcessId);
        view.addObject("btnList", btnList);
        return view;
    }

    /**
     * 根据流程定义id查询出所有的节点
     * @author wan
     * @param taProcessId
     * @return
     */
    @RequestMapping(value = "findProcessNodeAuthList", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findProcessNodeAuthList(String taProcessId, HttpServletRequest request, HttpServletResponse response){
        List<TaProcessNodeAuthVo> list = taProcessNodeAuthService.findProcessNodeAuthList(taProcessId);
        return new DataGrid(list, null);
    }

    /**
     * 保存流程节点配置
     * @author wan
     * @param jsonStr
     * @return
     */
    @RequestMapping(value = "saveConfig", method = {RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveConfig(String jsonStr){
        AjaxJson aj = new AjaxJson();
        try {
            List <TaProcessNodeAuthVo> voList = JSON.parseArray(jsonStr, TaProcessNodeAuthVo.class);
            taProcessNodeAuthService.saveConfig(voList);
            aj.setSuccess(true);
            aj.setMsg("保存成功");
            return aj;
        } catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("保存失败:" + e.getMessage());
            throw new BusinessException("数据库操作发生错误");
        }
    }
}
