package com.biz.eisp.activiti.designer.processconf.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessNodeEntityToTaProcessNodeVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessNodeVoToTaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.dict.service.TmDictDataService;

/**
 * 工作流设计节点元素管理 Controller.
 * <p>
 * 主要对工作流的设计节点元素信息进行CURD操作
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taProcessNodeController")
public class TaProcessNodeController extends BaseController{

	@Autowired
	private TaProcessNodeService taProcessNodeService;
	
	@Autowired
	private TmDictDataService tmDictDataService;
	
	/**
	 * 节点上的属性，走这个方法
	 * @author wan
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goProcessNodePropertiesForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goProcessNodePropertiesForm(HttpServletRequest request) {
		String turn = OConvertUtils.getString(request.getParameter("turn"));
		String id = OConvertUtils.getString(request.getParameter("id"));// 流程当前节点Id
		String checkbox = OConvertUtils.getString(request.getParameter("checkbox"));// 设置单选多选
		String processId = OConvertUtils.getString(request.getParameter("processId"));// 流程key
		//FIXME 各个页面中存在一些混乱,某些使用中processId其实是activiti流程定义 processKey, 而有一些地方是使用的TPProcesss.id
		// 此处开始尝试进行清理.
		String processDefinitionId = OConvertUtils.getString(request.getParameter("processDefinitionId"));
		TaProcessEntity taProcessEntity = taProcessNodeService.findUniqueByProperty(TaProcessEntity.class, "id", processDefinitionId);
		
		if (taProcessEntity != null) {
			request.setAttribute("processDefinitionId", taProcessEntity.getId());
			
			if(taProcessEntity.getTmDictDataEntity() != null){
				request.setAttribute("typeId", taProcessEntity.getTmDictDataEntity().getId());
			}
			processId = taProcessEntity.getProcessKey();
			request.setAttribute("listenerClass", taProcessEntity.getListenerClass());
			request.setAttribute("tableName", taProcessEntity.getTableName());
			request.setAttribute("redirectUrl", taProcessEntity.getRedirectUrl());
		}
		request.setAttribute("checkbox", checkbox);
		request.setAttribute("id", id);
		request.setAttribute("processId", processId);
		request.setAttribute("key", processId);
		return new ModelAndView("com/biz/eisp/activiti/designer/processconf/processnode/" + turn + "");
	}
	/**
	 * 点击流程配置，跳转到配置主页面
	 * @author wan
	 * @param pdId 流程id
	 * @return
	 */
	@RequestMapping(value = "goTaProcessTabs", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessTabs(String processId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessTabs");
		view.addObject("processId", processId);
		return view;
	}
	//http://localhost:8080/eisp/taProcessNodeController.do?goTaProcessNodeMain&pdKey=leave2
	/**
	 * 跳转到流程节点主页面
	 * @author wan
	 * @param pdId 流程Id
	 * @return
	 */
	@RequestMapping(value = "goTaProcessNodeMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessNodeMain(String taProcessId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessNodeMain");
		view.addObject("taProcessId", taProcessId);
		return view;
	}
	/**
	 * 根据流程定义id查询出所有的节点
	 * @author wan
	 * @param pdId
	 * @return
	 */
	@RequestMapping(value = "findNodeBypdKey", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findNodeBypdKey(String taProcessId,HttpServletRequest request,HttpServletResponse response){
		Page page = new EuPage(request);
		List<TaProcessNodeVo> list = taProcessNodeService.getNodeByProcessId(taProcessId, page);
		return new DataGrid(list, page);
	}
	/**
	 * 跳转到编辑或者新增页面
	 * @author wan
	 * @param nodeVo
	 * @param taProcessId
	 * @return
	 */
	@RequestMapping(value = "goTaProcessNodeFrom", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaProcessNodeForm(String id,String taProcessId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taProcessNodeForm");
		TaProcessNodeVo vo = null;
		if(StringUtils.isNotBlank(id)){
			TaProcessNodeEntity entity = taProcessNodeService.get(TaProcessNodeEntity.class, id);
			vo = new TaProcessNodeEntityToTaProcessNodeVo().apply(entity);
		}else{
			vo = new TaProcessNodeVo();
			vo.setTaProcessId(taProcessId);
		}
		view.addObject("nodeVo", vo);
		return view;
	}
	/**
	 * 新增或者修改流程节点
	 * @author wan
	 * @param nodeVo
	 * @return
	 */
	@RequestMapping(value = "saveOrUpdateTaProcessNode", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateTaProcessNode(TaProcessNodeVo nodeVo){
		AjaxJson aj = new AjaxJson();
		TaProcessNodeEntity entity = new TaProcessNodeVoToTaProcessNodeEntity(taProcessNodeService).apply(nodeVo);
		TaProcessEntity pe = taProcessNodeService.get(TaProcessEntity.class, nodeVo.getTaProcessId());
		try {
			taProcessNodeService.saveOrUpdate(pe);
			aj.setSuccess(true);
			return aj;
		} catch (Exception e) {
			aj.setSuccess(false);
			throw new BusinessException("数据库操作发生错误");
		}
	}
	/**
	 * 删除节点
	 * @author wan
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "deleteTaProcessodeById", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteTaProcessNodeById(String id){
		AjaxJson aj = new AjaxJson();
		String message = null;
		TaProcessNodeEntity entity = taProcessNodeService.get(TaProcessNodeEntity.class, id);
		if(entity.getTaProcessVariableEntityList().size()!=0&&entity.getTaRProcessNodeListenerEntityList().size()!=0){
			message = "节点:" + entity.getProcessNodeName() +"已经在使用，无法删除，请先将正在使用该节点的变量或者监听删除";
		}else{
			taProcessNodeService.delete(entity);
			message = "成功删除节点:" + entity.getProcessNodeName();
		}
		aj.setMsg(message);
		return aj;
	}
	/**
	 * 验证节点
	 * @author grover
	 * @param nodeVo 节点vo
	 * @param param 输入值
	 * @return 验证对象
	 */
	@RequestMapping(value = "validateNode", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public ValidForm validateNode(TaProcessNodeVo nodeVo,String param){
		ValidForm vf = new ValidForm();
		try {
			vf = taProcessNodeService.validateNode(nodeVo, param);
		} catch (Exception e) {
			vf.setStatus("n");
			vf.setInfo("服务器验证错误,请重试");
		}
		return vf;
	}
}
