package com.biz.eisp.activiti.designer.processconf.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.biz.eisp.activiti.designer.processconf.service.TaRProcessNodeListenerService;
import com.biz.eisp.activiti.designer.processconf.vo.TaListenerVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaRProcessNodeListenerVo;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;

/**
 * 工作流程与监听器关系管理 Controller.
 * <p>
 * 
 * 主要处理工作流程与监听器关系CURD操作
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taRProcessNodeListenerController")
public class TaRProcessNodeListenerController extends BaseController {

	private TaRProcessNodeListenerService taRProcessNodeListenerService;

	/**
	 * 查询流程节点关联的监听器列表信息.
	 * <p>
	 * 
	 * @param taRProcessNodeListenerVo
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "findTaProcessListenerList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTpProcessListenerList(TaRProcessNodeListenerVo taRProcessNodeListenerVo,
			HttpServletRequest request) {
		Page page = new EuPage(request);
		List<TaListenerVo> taRProcessNodeListenerVoList = taRProcessNodeListenerService
				.findTaProcessNodeListenerList(taRProcessNodeListenerVo, page);
		return new DataGrid(taRProcessNodeListenerVoList, page);
	}

}
