package com.biz.eisp.activiti.designer.processconf.dao;

import java.util.List;

import com.biz.eisp.activiti.designer.processconf.entity.TaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaActRoleVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.mdm.position.vo.TmPositionVo;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author wan
 * @version v1.0
 */
@InterfaceDao
public interface TaActRoleDao {
	/**
	 * 获取角色信息.
	 * <p>根据当前职位获取有效的角色集合信息
	 * @author grover
	 * @param PosId 职位id
	 * @return 角色集合
	 */
	@ResultType(TaActRoleEntity.class)
	@Arguments({"taActRoleVo","page"})
	List<TaActRoleEntity> getActRoleListByCurrentPosId(TaActRoleVo taActRoleVo, Page page);
	
	@ResultType(TmPositionVo.class)
	@Arguments({"tmPositionVo","roleCode","page"}) 
	List <TmPositionVo> findPositionByRoleCode(TmPositionVo tmPositionVo, String roleCode, Page page);
}
