package com.biz.eisp.activiti.designer.processconf.dao;

import com.biz.eisp.activiti.designer.processconf.vo.TaProcessFunctionAuthVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;

import java.util.List;

/**
 * Created by liukai on 2018/1/15.
 * 菜单中可以选取的流程配置 Dao
 */
@InterfaceDao
public interface TaProcessFunctionAuthDao {

    /**
     * 查询配置列表
     * @param vo
     * @param page
     * @return
     */
    @Arguments({"vo","page"})
    @ResultType(TaProcessFunctionAuthVo.class)
    public List<TaProcessFunctionAuthVo> findTaProcessFunctionAuthVoList(TaProcessFunctionAuthVo vo, Page page);

    /**
     * 查询该组织及其以下组织的该菜单下的所有流程列表
     * @param functionId
     * @param orgCode
     * @return
     */
    @Arguments({"functionId","orgCode"})
    @ResultType(TaProcessFunctionAuthVo.class)
    public List<TaProcessFunctionAuthVo> findTaProcessListByFunctionId(String functionId, String orgCode);
}
