package com.biz.eisp.activiti.designer.processconf.entity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.log.curd.Loggerable;
import com.biz.eisp.log.curd.ModifyObject;

/** 
 * 工作流角色表
 * @author wan
 * @version v1.0
 */
@Entity
@Table(name = "TM_ACT_ROLE")
public class TaActRoleEntity extends IdEntity implements Serializable,Loggerable{
	private static final long serialVersionUID = 1L;
	//角色名称
	private String roleName;
	//角色编码
	private String roleCode;
	//创建时间
	private Date createDate;
	//创建人ID
	private String createName;
	//修改时间
	private Date updateDate;
	//修改人
	private String updateName;
	//状态 0删除 1正常
	private Integer enableState;
	//修改人
	private String headString;
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 角色名称
	 */
	@Column(name = "role_name", nullable = false, length = 50)
	public String getRoleName() {
		return this.roleName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 角色名称
	 */
	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 角色编码
	 */
	@Column(name = "role_code", length = 30)
	public String getRoleCode() {
		return this.roleCode;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 角色编码
	 */
	public void setRoleCode(String roleCode) {
		this.roleCode = roleCode;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  创建时间
	 */
	@Column(name ="create_date",nullable=true)
	public Date getCreateDate(){
		return this.createDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  创建时间
	 */
	public void setCreateDate(Date createDate){
		this.createDate = createDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  创建人ID
	 */
	@Column(name ="create_name",nullable=true,length=32)
	public String getCreateName(){
		return this.createName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  创建人ID
	 */
	public void setCreateName(String createName){
		this.createName = createName;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  修改时间
	 */
	@Column(name ="update_date",nullable=true)
	public Date getUpdateDate(){
		return this.updateDate;
	}
	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  修改时间
	 */
	public void setUpdateDate(Date updateDate){
		this.updateDate = updateDate;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修改人ID
	 */
	@Column(name ="update_name",nullable=true,length=32)
	public String getUpdateName(){
		return this.updateName;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修改人ID
	 */
	public void setUpdateName(String updateName){
		this.updateName = updateName;
	}
	/**
	 *方法: 取得 java.lang.Integer
	 *@return: java.lang.Integer 状态
	 */
	@Column(name = "enable_state", length = 5)
	public Integer getEnableState() {
		return enableState;
	}
	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer 状态
	 */
	public void setEnableState(Integer enableState) {
		this.enableState = enableState;
	}
	/**
	 *方法: 取得 java.lang.String
	 *@return: java.lang.String 状态
	 */
	@Column(name = "headstring", length = 50)
	public String getHeadString() {
		return headString;
	}
	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String 角色名称拼音简写
	 */
	public void setHeadString(String headString) {
		this.headString = headString;
	}
	
	
	@Override
	public String businessDesc() {
		return "工作流角色信息";
	}
	
	@Override
	public String addLogContent() {
		String content ="字段[<b>角色名称</b>]:"+this.getRoleName()+
					   "<br>字段[<b>角色编码</b>]:"+this.getRoleCode();
		return content;
	}
	
	@Override
	public String updateLogContent(List<ModifyObject> modifyFieldList) {
		return null;
	}
	
}
