package com.biz.eisp.activiti.designer.processconf.entity;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/**
 * Activiti监听器实体.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "ta_listener")
public class TaListenerEntity extends IdEntity implements java.io.Serializable {
	private static final long serialVersionUID = 3410861946748945910L;

	// 监听事件
	private String listenerEvent;
	// 执行类型
	private String listenerType;
	// 执行内容
	private String listenerValue;
	// 名称
	private String listenerName;
	// 监听器状态 0：已禁用 1：已启用
	private Short listenerState;
	// 监听器与节点关系列表
	private List<TaRProcessNodeListenerEntity> taRProcessNodeListenerEntityList = new ArrayList<>(0);
	//监听类型   1.执行监听器 2.任务监听器
	private Short typeId;

	@Column(name = "listener_event", length = 20)
	public String getListenerEvent() {
		return listenerEvent;
	}
	
	@Column(name = "type_id")
	public Short getTypeId(){
		return this.typeId;
	}
	
	public void setTypeId(Short typeId){
		this.typeId = typeId;
	}
	public void setListenerEvent(String listenerEvent) {
		this.listenerEvent = listenerEvent;
	}

	@Column(name = "listener_type", length = 20)
	public String getListenerType() {
		return listenerType;
	}

	public void setListenerType(String listenerType) {
		this.listenerType = listenerType;
	}

	@Column(name = "listener_value", length = 100)
	public String getListenerValue() {
		return listenerValue;
	}

	public void setListenerValue(String listenerValue) {
		this.listenerValue = listenerValue;
	}

	@Column(name = "listener_name", length = 50)
	public String getListenerName() {
		return listenerName;
	}

	public void setListenerName(String listenerName) {
		this.listenerName = listenerName;
	}

	@Column(name = "listener_state")
	public Short getListenerState() {
		return listenerState;
	}

	public void setListenerState(Short listenerState) {
		this.listenerState = listenerState;
	}

	@Fetch(FetchMode.SUBSELECT)
	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "taListenerEntity")
	public List<TaRProcessNodeListenerEntity> getTaRProcessNodeListenerEntityList() {
		return taRProcessNodeListenerEntityList;
	}

	public void setTaRProcessNodeListenerEntityList(
			List<TaRProcessNodeListenerEntity> taRProcessNodeListenerEntityList) {
		this.taRProcessNodeListenerEntityList = taRProcessNodeListenerEntityList;
	}

}
