package com.biz.eisp.activiti.designer.processconf.entity;

import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessVariableEntity;
import com.biz.eisp.base.common.identity.IdEntity;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Activiti 流程设计中的节点信息实体.
 * <p>
 * 此实体保存流程设计中的节点信息，包括：事件，任务等所有节点元素信息 注意：任务中的指派人是保存在工作流的xml文件中的
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "ta_process_node_pro")
public class TaProcessNodeProEntity extends IdEntity implements java.io.Serializable {
	private static final long serialVersionUID = 7607567366428339251L;

	// 所属流程
	private String processId;
	/**流程版本*/
	private String procDefId;

	// 节点名称
	private String processNodeName;
	// 节点编号
	private String processNodeCode;
	// 外部表单跳转方法
	private String modelandview;
	//角色编码
	private String roleCode;

	//岗位编码
	private String positionCode;
	//是否会签
	private Integer sign;
	//排序
	private Integer sort;
	//角色过滤
	private Integer filter;
	//空节点自动跳过 Y 跳过， N 不跳过。 提出错误
	private String nullJumpNode;
	//重复节点跳过  Y 跳过， N 不跳过，要求再次审批
	private String duplicateJumpNode;

	@Column(name = "process_Id", length = 50)
	public String getProcessId() {
		return processId;
	}
	@Column(name = "proc_Def_Id", length = 50)
	public String getProcDefId() {
		return procDefId;
	}

	public void setProcessId(String processId) {
		this.processId = processId;
	}

	public void setProcDefId(String procDefId) {
		this.procDefId = procDefId;
	}

	@Column(name = "process_node_name", length = 50)
	public String getProcessNodeName() {
		return processNodeName;
	}

	public void setProcessNodeName(String processNodeName) {
		this.processNodeName = processNodeName;
	}

	@Column(name = "process_node_code", length = 50)
	public String getProcessNodeCode() {
		return processNodeCode;
	}

	public void setProcessNodeCode(String processNodeCode) {
		this.processNodeCode = processNodeCode;
	}

	@Column(name = "modelandview", length = 50)
	public String getModelandview() {
		return modelandview;
	}

	public void setModelandview(String modelandview) {
		this.modelandview = modelandview;
	}
	
	@Column(name = "ROLE_CODE")
	public String getRoleCode() {
		return roleCode;
	}
	public void setRoleCode(String roleCode) {
		this.roleCode = roleCode;
	}
	
	@Column(name = "POSITION_CODE")
	public String getPositionCode() {
		return positionCode;
	}
	public void setPositionCode(String positionCode) {
		this.positionCode = positionCode;
	}
	
	@Column(name = "sign")
	public Integer getSign() {
		return sign;
	}
	public void setSign(Integer sign) {
		this.sign = sign;
	}
	@Column(name = "sort")
	public Integer getSort() {
		return sort;
	}
	public void setSort(Integer sort) {
		this.sort = sort;
	}
	@Column(name = "filter")
	public Integer getFilter() {
		return filter;
	}
	public void setFilter(Integer filter) {
		this.filter = filter;
	}

	@Column(name = "null_jump_node")
	public String getNullJumpNode() {
		return nullJumpNode;
	}

	public void setNullJumpNode(String nullJumpNode) {
		this.nullJumpNode = nullJumpNode;
	}

	@Column(name = "duplicate_jump_node")
	public String getDuplicateJumpNode() {
		return duplicateJumpNode;
	}

	public void setDuplicateJumpNode(String duplicateJumpNode) {
		this.duplicateJumpNode = duplicateJumpNode;
	}
}
