package com.biz.eisp.activiti.designer.processconf.entity;

import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessVariableEntity;
import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.mdm.dict.entity.TmDictDataEntity;
import com.biz.eisp.mdm.user.entity.TmUserEntity;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 工作流设计主实体表.
 * <p>
 * 工作流设计主实体表，设计中的主表，节点表为（ta_process_node），及其与监听器的关系表（ta_r_processnode_listener）
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "ta_process_pro")
public class TaProcessProEntity extends IdEntity implements java.io.Serializable {
	// 流程类型
	private TmDictDataEntity tmDictDataEntity;
	// 创建人
	private TmUserEntity tmUserEntity;
	// 流程名称
	private String processName;
	// 流程状态
	private Short processState;
	// 流程物理路径
	private String processXmlpath;
	// 流程二进制文件
	private byte[] processXml;
	// 流程唯一Key
	private String processKey;
	// 流程描述
	private String note;
	// 监听器类
	private String listenerClass;
	// 表名
	private String tableName;
	// 重定向url
	private String redirectUrl;

	/**流程版本*/
	private String procDefId;

	@Column(name = "process_name", length = 50)
	public String getProcessName() {
		return processName;
	}

	public void setProcessName(String processName) {
		this.processName = processName;
	}

	@Column(name = "process_state")
	public Short getProcessState() {
		return processState;
	}

	public void setProcessState(Short processState) {
		this.processState = processState;
	}

	@Column(name = "process_xmlpath", length = 100)
	public String getProcessXmlpath() {
		return processXmlpath;
	}

	public void setProcessXmlpath(String processXmlpath) {
		this.processXmlpath = processXmlpath;
	}

	@Column(name = "process_xml")
	public byte[] getProcessXml() {
		return processXml;
	}

	public void setProcessXml(byte[] processXml) {
		this.processXml = processXml;
	}

	@Column(name = "process_key", length = 100)
	public String getProcessKey() {
		return processKey;
	}

	public void setProcessKey(String processKey) {
		this.processKey = processKey;
	}


	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "type_id")
	public TmDictDataEntity getTmDictDataEntity() {
		return tmDictDataEntity;
	}

	public void setTmDictDataEntity(TmDictDataEntity tmDictDataEntity) {
		this.tmDictDataEntity = tmDictDataEntity;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "user_id")
	public TmUserEntity getTmUserEntity() {
		return tmUserEntity;
	}

	public void setTmUserEntity(TmUserEntity tmUserEntity) {
		this.tmUserEntity = tmUserEntity;
	}

	@Column(name = "note", length = 200)
	public String getNote() {
		return this.note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	@Column(name = "listener_class", nullable = true, length = 100)
	public String getListenerClass() {
		return this.listenerClass;
	}

	/**
	 * 方法: 设置String 描述: 属性set方法
	 * 
	 * @param: String
	 *             监听器类
	 */
	public void setListenerClass(String listenerClass) {
		this.listenerClass = listenerClass;
	}

	/**
	 * 方法: 取得String
	 * 
	 * @return: String 表名
	 */
	@Column(name = "table_name", nullable = true, length = 50)
	public String getTableName() {
		return this.tableName;
	}

	/**
	 * 方法: 设置String 描述: 属性set方法
	 * 
	 * @param: String
	 *             表名
	 */
	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	/**
	 * 方法: 取得String
	 * 
	 * @return: String 重定向url
	 */
	@Column(name = "redirect_url", nullable = true, length = 100)
	public String getRedirectUrl() {
		return this.redirectUrl;
	}

	/**
	 * 方法: 设置String 描述: 属性set方法
	 * 
	 * @param: String
	 *             重定向url
	 */
	public void setRedirectUrl(String redirectUrl) {
		this.redirectUrl = redirectUrl;
	}

	@Column(name = "proc_Def_Id", length = 50)
	public String getProcDefId() {
		return procDefId;
	}


	public void setProcDefId(String procDefId) {
		this.procDefId = procDefId;
	}

}
