package com.biz.eisp.activiti.designer.processconf.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.base.common.identity.IdEntity;

/**
 * 流程节点与监听器关系信息.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "ta_r_processnode_listener")
public class TaRProcessNodeListenerEntity extends IdEntity implements java.io.Serializable {
	// 监听器
	private TaListenerEntity taListenerEntity;
	// 流程节点
	private TaProcessNodeEntity taProcessNodeEntity;
	// 所属流程
	private TaProcessEntity taProcessEntity;
	// 节点名称
	private String nodename;
	// 监听状态
	private Short status;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "listener_id")
	public TaListenerEntity getTaListenerEntity() {
		return taListenerEntity;
	}

	public void setTaListenerEntity(TaListenerEntity taListenerEntity) {
		this.taListenerEntity = taListenerEntity;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "porcess_node_id")
	public TaProcessNodeEntity getTaProcessNodeEntity() {
		return taProcessNodeEntity;
	}

	public void setTaProcessNodeEntity(TaProcessNodeEntity taProcessNodeEntity) {
		this.taProcessNodeEntity = taProcessNodeEntity;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "process_id")
	public TaProcessEntity getTaProcessEntity() {
		return taProcessEntity;
	}

	public void setTaProcessEntity(TaProcessEntity taProcessEntity) {
		this.taProcessEntity = taProcessEntity;
	}

	@Column(name = "nodename", length = 50)
	public String getNodename() {
		return nodename;
	}

	public void setNodename(String nodename) {
		this.nodename = nodename;
	}

	@Column(name = "status")
	public Short getStatus() {
		return status;
	}

	public void setStatus(Short status) {
		this.status = status;
	}

}