package com.biz.eisp.activiti.designer.processconf.service;

import java.util.List;

import com.biz.eisp.activiti.designer.processconf.vo.TaProcessDefinitionVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

/**
 * 流程定义Service 接口.
 * <p>
 * 主要处理工作流定义相关的CURD操作
 * 
 * @author liukai
 * @version v1.0
 */
public interface TaProcessDefinitionService extends BaseService {

	/**
	 * 查询流程定义列表.
	 * <p>
	 * 
	 * @param taProcessDefinitionVo
	 *            流程定义Vo对象，必须传递processDefinitionKey，更新流程key查询
	 * @param page
	 *            页面对象
	 * @return 流程定义Vo对象列表
	 */
	List<TaProcessDefinitionVo> findProcessDefinitionList(TaProcessDefinitionVo taProcessDefinitionVo, Page page);

	/**
	 * 删除流程定义，流程版本.
	 * <p>
	 * 
	 * @param taProcessDefinitionVo
	 *            流程定义Vo对象，必须传递deploymentId，processDefinitionKey，根据deploymentId，
	 *            processDefinitionKey进行删除
	 */
	public void deleteProcessDefinition(TaProcessDefinitionVo taProcessDefinitionVo);
}
