package com.biz.eisp.activiti.designer.processconf.service;

import com.biz.eisp.activiti.designer.processconf.vo.TaProcessFunctionAuthVo;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

import java.util.List;

/**
 * Created by liukai on 2018/1/15.
 * 菜单中可以选取的流程配置 Service
 */
public interface TaProcessFunctionAuthService extends BaseService {

    /**
     * 查询配置列表
     * @param vo
     * @param page
     * @return
     */
    public List<TaProcessFunctionAuthVo> findTaProcessFunctionAuthVoList(TaProcessFunctionAuthVo vo, Page page);

    /**
     * 保存配置
     * @param vo
     */
    public ValidForm saveTaProcessFunctionAuth(TaProcessFunctionAuthVo vo);

    /**
     * 删除配置
     * @param id
     * @return
     */
    public ValidForm deleteTaProcessFunctionAuthVo(String id);

    /**
     * 获取配置信息
     * @param id
     * @return
     */
    public TaProcessFunctionAuthVo getTaProcessFunctionAuthVo(String id);

    /**
     * 查询当前登录组织及其以下组织的该菜单下的所有流程列表，
     * @param functionId 菜单id
     * @return
     */
    public List <TaProcessFunctionAuthVo> findTaProcessListByFunctionId(String functionId);

    /**
     * 查询该组织及其以下组织的该菜单下的所有流程列表
     * @param functionId 菜单Id
     * @param orgCode 组织编码
     * @return
     */
    public List <TaProcessFunctionAuthVo> findTaProcessListByFunctionId(String functionId, String orgCode);
}
