package com.biz.eisp.activiti.designer.processconf.service;

import java.util.List;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

/**
 * 工作流设计节点元素管理 Service接口.
 * <p>
 * 主要对工作流的设计节点元素信息进行CURD操作
 * @author liukai
 * @version v1.0
 */
public interface TaProcessNodeService extends BaseService{

	public TaProcessNodeEntity getTaProcessNodeEntity(String taskDefinitionKey, String processkey);
	/**
	 * 根据流程process的id查询出所有的node
	 * @author wan
	 * @param processId
	 * @return
	 */
	public List<TaProcessNodeVo> getNodeByProcessId(String processId,Page page);
	/**
	 * 根据流程process的id查询出所有的node
	 * @author wan
	 * @param pdKey 流程key
	 * @return
	 */
	public List<TaProcessNodeVo> getNodeByProcessId(String processId);
	public List<TaProcessNodeEntity> getNodeEntityByProcessId(String processId);
	/**
	 * 验证节点重复.
	 * @author grover
	 * @param nodeVo 节点vo
	 * @param param 输入值
	 * @return 验证信息
	 */
	public ValidForm validateNode(TaProcessNodeVo nodeVo, String param);

	/**
	 * 根据 版本查询数据
	 * @param processVersion
	 * @param taskDefinitionKey
	 * @return
	 */
	public TaProcessNodeProEntity getTaProcessNodeByVersionKey(String processVersion, String taskDefinitionKey);

	/**
	 * 找到对应的历史数据
	 * @param processVersion
	 * @param processNodeId
	 * @return
	 */
	public TaProcessNodeAuthProEntity getTaProcessNodeAuthEntity(String processVersion,String processNodeId);
}
