package com.biz.eisp.activiti.designer.processconf.service;

import com.biz.eisp.activiti.designer.processconf.entity.TaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaActRoleVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

/**
 * 工作流角色扩展接口定义.
 * <p>
 * 工作流角色在保存或者编辑时的扩展,如需扩展则需要实现该接口.
 * @author grover
 * @version v1.0
 */
public interface TaRoleExtendService extends BaseService{

	/**
	 * 验证保存数据.
	 * <p>
	 * 
	 * @param vo
	 * @param page
	 * @return 验证失败throw new BusinessException("失败内容")
	 */
	public void validate(TaActRoleVo vo, Page page);

	/**
	 * 保存工作流角色信息前操作(并且没有做Vo到Entity的转换操作).
	 * <p>
	 * 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做Vo转换到Entity的操作。
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回null即保存前不做任何操作。 返回Entity后，系统即保存返回的Entity。不再做Vo转换到Entity的操作。
	 */
	public TaActRoleEntity saveBefore(TaActRoleVo vo, Page page);

	/**
	 * 保存工作流角色信息前操作（已经做了vo到Entity的转换操作）.
	 * <p>
	 * 
	 * @param entity
	 *            Vo转换成Entity的值，该Entity，如果是新增操作即为游离态，修改操作即为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，系统即保存返回的Entity。
	 */
	public TaActRoleEntity saveBefore(TaActRoleEntity entity, TaActRoleVo vo, Page page);

	/**
	 * 保存工作流角色后操作.
	 * <p>
	 * 
	 * @param entity
	 *            保存后的Entity对象，该Entity状态为持久态
	 * @param vo
	 *            vo对象值
	 * @param page
	 *            页面对象
	 * @return 返回Entity后，后面的其他操作，都会使用该Entity
	 */
	public TaActRoleEntity savePost(TaActRoleEntity entity, TaActRoleVo vo, Page page);
}
