package com.biz.eisp.activiti.designer.processconf.service;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.biz.eisp.activiti.designer.processconf.entity.TaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaActRoleVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;



/**
 * 工作流角色service
 * @author wan
 * @version v1.0
 */
public interface TaRoleService extends BaseService{
	/**
	 * 解析xml中的assignee,candidateGroups
	 * <p>读取数据库中的processDefinition，然后解析对应的各自的xml，最后将得到的assignee返回<br>
	 * @author wan
	 * @param tmRoleVo : 角色vo
	 * @return List<String>：是xml中，全部的角色
	 */
	Set<String> getInXmlCandidateGroupss(String roleCode);
	/**
	 * 获取角色信息.
	 * <p>根据当前职位获取有效的角色集合信息
	 * @author grover
	 * @param tmRoleVo 角色vo
	 * @param page 分页对象
	 * @return 角色集合
	 * @throws BusinessException 运行过程中可能出现的异常
	 */
	List<TaActRoleEntity> getRoleListByCurrentPosId(TaActRoleVo taActRoleVo, Page page) throws BusinessException;
	
	
	List<TaActRoleVo> findActRoleList(TaActRoleVo taActRoleVo, Page page);

	/**
	 * 新增权限角色
	 * @param taActRoleVo 角色vo信息
	 * @param page 页面对象
	 */
	void createTmRole(TaActRoleVo taActRoleVo,Page page) throws BusinessException;

	/**
	 * 删除权限角色
	 * @param id 需要删除的权限角色的ID
	 * @return 返回删除成功的boolean值
	 * @exception SQLException 约束错误
	 */
	boolean deleteTmRole(String id) throws SQLException;

	/**
	 * 修改权限角色信息
	 * @param tmRole 修改之后的权限角色信息
	 * @return 返回修改成功的boolean值
	 */
	Map<String,String> updateTmRole(TaActRoleEntity taActRoleEntity);
	/**
	 * 验证角色.
	 * @author grover
	 * @param tmRole 角色对象
	 * @return 验证信息
	 */
	ValidForm validateTmRoleForm(TaActRoleEntity taActRoleEntity);
	/**
	 * 根据工作流角色code找寻对应的职位code
	 * @author wan
	 * @param roleCode
	 * @return
	 */
	List<TmPositionVo> findPositionByRoleCode(TmPositionVo tmPositionVo, String roleCode, Page page);
	
}
