package com.biz.eisp.activiti.designer.processconf.service.impl;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.designer.processconf.dao.TaListenerDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaListenerEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaListenerService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaListenerTransFormEntityToVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaListenerTransFormVoToEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaListenerVo;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.google.common.collect.Lists;

/**
 * 监听器管理 Service接口实现.
 * <p>
 * 
 * 主要管理监听器的CURD操作
 * 
 * @author liukai
 * @version v1.0
 */
@Service("taListenerService")
@Transactional
public class TaListenerServiceImpl extends BaseServiceImpl implements TaListenerService {
	@Autowired
	private TaListenerDao taListenerDao;
	
	@Override
	public List<TaListenerVo> findTaListenerList(TaListenerVo taListenerVo, Page page) {
		List<TaListenerVo> voList = taListenerDao.findTaListenerList(taListenerVo, page);
		return voList;
	}

	@Override
	public List<TaListenerVo> findTaListenerList(String ids, Page page) {
		String hql = "from TaListenerEntity t ";
		if(StringUtils.isNotBlank(ids)) {
			String [] newIds = StringUtil.wrapString(ids.split(","), "'");
			String i = StringUtils.join(newIds, ",");
			hql += "where t.id in (" + i + ")";
		} else {
			hql += "where t.id in ('')";
		}
		
		List<TaListenerEntity> entityList = this.findByHql(hql, page);
		
		List<TaListenerVo> voList = Lists.transform(entityList, new TaListenerTransFormEntityToVo());
		
		return voList;
	}
	
	@Override
	public void saveTaListener(TaListenerVo taListenerVo, Page page) {
		TaListenerEntity apply = new TaListenerTransFormVoToEntity(this).apply(taListenerVo);
		this.saveOrUpdate(apply);
	}

	@Override
	public TaListenerVo getTaListener(TaListenerVo taListenerVo,Page page) {
		TaListenerEntity entity = this.get(TaListenerEntity.class, taListenerVo.getId());
		TaListenerVo vo = new TaListenerTransFormEntityToVo().apply(entity);
		return vo;
	}
	
}
