package com.biz.eisp.activiti.designer.processconf.service.impl;

import java.util.List;

import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.dao.TaProcessDefinitionDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaRRoleProcDefEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessDefinitionService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessDefinitionVo;
import com.biz.eisp.activiti.entity.activiti.ActHiProcinstEntity;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;

/**
 * 流程定义Service 实现.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Service("taProcessDefinitionService")
@Transactional
public class TaProcessDefinitionServiceImpl extends BaseServiceImpl implements TaProcessDefinitionService {

	@Autowired(required = false)
	private RepositoryService repositoryService;

	@Autowired
	private TaProcessDefinitionDao taProcessDefinitionDao; //注入流程定义InterfaceDao

	@Override
	public List<TaProcessDefinitionVo> findProcessDefinitionList(TaProcessDefinitionVo taProcessDefinitionVo,
			Page page) {
		if(StringUtils.isBlank(taProcessDefinitionVo.getProcessDefinitionKey())) {
			throw new BusinessException("没有传递流程定义key");
		}
		List<TaProcessDefinitionVo> voList = taProcessDefinitionDao.findProcessDefinitionList(taProcessDefinitionVo,
				page);
		return voList;
	}

	@Override
	public void deleteProcessDefinition(TaProcessDefinitionVo taProcessDefinitionVo) {
		String deploymentId = taProcessDefinitionVo.getDeploymentId();
		String processDefinitionKey = taProcessDefinitionVo.getProcessDefinitionKey();

		TaProcessEntity taProcessEntity = this.findUniqueByProperty(TaProcessEntity.class, "processKey",
				processDefinitionKey); //获取该流程实体信息，用于还原流程状态为：未发布
		ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery()
				.deploymentId(deploymentId).processDefinitionKey(processDefinitionKey).singleResult();
		List<ActHiProcinstEntity> actHiProcinsts = this.findByProperty(ActHiProcinstEntity.class, "procDefId",
				processDefinition.getId()); //查询流程定义实例列表
		if (actHiProcinsts.size() <= 0) {
			repositoryService.deleteDeployment(deploymentId, true);
			this.deleteTaRRoleDef(deploymentId);
			taProcessEntity.setProcessState(WorkFlowGlobals.PROCESS_DEPLOY_NO);
			this.updateEntity(taProcessEntity);// 还原流程为未发布状态
		} else {
			throw new BusinessException("流程跟业务已关联无法删除");
		}
	}

	private void deleteTaRRoleDef(String deploymentId) {
		List <TaRRoleProcDefEntity> list = this.findByProperty(TaRRoleProcDefEntity.class, "deploymentId", deploymentId);
		this.deleteAllEntity(list);
	}
}
