package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.dao.TaProcessFunctionAuthDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessFunctionAuthEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessFunctionAuthService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessFunctionAuthEntityToTaProcessFunctionAuthVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessFunctionAuthVoToTaProcessFunctionAuthEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessFunctionAuthVo;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by liukai on 2018/1/15.
 */
@Service("taProcessFunctionAuthService")
@Transactional
public class TaProcessFunctionAuthServiceImpl extends BaseServiceImpl implements TaProcessFunctionAuthService {

    @Autowired
    private TaProcessFunctionAuthDao taProcessFunctionAuthDao;

    @Override
    public List<TaProcessFunctionAuthVo> findTaProcessFunctionAuthVoList(TaProcessFunctionAuthVo vo, Page page) {
        List<TaProcessFunctionAuthVo> list = taProcessFunctionAuthDao.findTaProcessFunctionAuthVoList(vo, page);
        return list;
    }

    @Override
    public ValidForm saveTaProcessFunctionAuth(TaProcessFunctionAuthVo vo) {
        ValidForm validForm = validSaveOpt(vo);

        TaProcessFunctionAuthEntity entity = new TaProcessFunctionAuthVoToTaProcessFunctionAuthEntity().apply(vo);
        this.saveOrUpdate(entity);

        return validForm;
    }

    /**
     * 验证保存操作
     *
     * @param vo
     * @return
     */
    private ValidForm validSaveOpt(TaProcessFunctionAuthVo vo) {
        ValidForm validForm = new ValidForm();
        validForm.setStatus("Y");
        validForm.setInfo("验证成功");

        return validForm;
    }

    @Override
    public ValidForm deleteTaProcessFunctionAuthVo(String id) {
        ValidForm validForm = validDeleteOpt(id);

        TaProcessFunctionAuthEntity entity = this.get(TaProcessFunctionAuthEntity.class, id);

        this.delete(entity);

        return validForm;
    }

    /**
     * 验证删除操作
     *
     * @param id
     * @return
     */
    private ValidForm validDeleteOpt(String id) {
        ValidForm validForm = new ValidForm();
        validForm.setStatus("Y");
        validForm.setInfo("验证成功");

        return validForm;
    }

    @Override
    public TaProcessFunctionAuthVo getTaProcessFunctionAuthVo(String id) {
        TaProcessFunctionAuthEntity entity = this.get(TaProcessFunctionAuthEntity.class, id);
        return new TaProcessFunctionAuthEntityToTaProcessFunctionAuthVo().apply(entity);
    }

    @Override
    public List<TaProcessFunctionAuthVo> findTaProcessListByFunctionId(String functionId) {
        return taProcessFunctionAuthDao.findTaProcessListByFunctionId(functionId, ResourceConfigUtils.getCurrOrg().getOrgCode());
    }

    @Override
    public List<TaProcessFunctionAuthVo> findTaProcessListByFunctionId(String functionId, String orgCode) {
        if(StringUtil.isBlank(orgCode)) {
            return findTaProcessListByFunctionId(functionId);
        }
        return taProcessFunctionAuthDao.findTaProcessListByFunctionId(functionId,
                ResourceConfigUtils.getCurrOrg().getOrgCode());
    }
}
