package com.biz.eisp.activiti.designer.processconf.service.impl;

import java.util.ArrayList;
import java.util.List;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthProEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessNodeEntityToTaProcessNodeVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;

/**
 * 工作流设计节点元素管理 Service接口实现.
 * <p>
 * 主要对工作流的设计节点元素信息进行CURD操作
 * @author liukai
 * @version v1.0
 */
@Service("taProcessNodeService")
@Transactional
public class TaProcessNodeServiceImpl extends BaseServiceImpl implements TaProcessNodeService{

	@Override
	public TaProcessNodeEntity getTaProcessNodeEntity(String taskDefinitionKey, String processkey) {
		String hql = "from TaProcessNodeEntity t where t.taProcessEntity.processKey = ? and t.processNodeCode = ?";
		List <TaProcessNodeEntity> entityList = this.findByHql(hql, processkey, taskDefinitionKey);
		if(entityList != null && entityList.size() > 0) {
			return entityList.get(0);
		}
		return null;
	}

	@Override
	public List<TaProcessNodeVo> getNodeByProcessId(String processId,Page page) {
		String hql = "from TaProcessNodeEntity t where t.taProcessEntity.id = ? order by t.sort asc";
		List<TaProcessNodeEntity> list = findByHql(hql, page, processId);
		List<TaProcessNodeVo> result = new ArrayList<>();
		for(TaProcessNodeEntity entity : list){
			TaProcessNodeVo vo = new TaProcessNodeEntityToTaProcessNodeVo().apply(entity);
			result.add(vo);
		}
		return result;
	}
	@Override
	public List<TaProcessNodeVo> getNodeByProcessId(String processId) {
		String hql = "from TaProcessNodeEntity t where t.taProcessEntity.id = ?";
		List<TaProcessNodeEntity> list = findByHql(hql, processId);
		List<TaProcessNodeVo> result = new ArrayList<>();
		for(TaProcessNodeEntity entity : list){
			TaProcessNodeVo vo = new TaProcessNodeEntityToTaProcessNodeVo().apply(entity);
			result.add(vo);
		}
		return result;
	}

	@Override
	public List<TaProcessNodeEntity> getNodeEntityByProcessId(String processId) {
		String hql = "from TaProcessNodeEntity t where t.taProcessEntity.id = ?";
		List<TaProcessNodeEntity> result = findByHql(hql, processId);
		return result;
	}

	@Override
	public ValidForm validateNode(TaProcessNodeVo nodeVo, String param) {
		ValidForm v = new ValidForm();
		if(StringUtil.isNotEmpty(nodeVo.getId())){
			//修改
			if("1".equals(nodeVo.getFlag())){
				String sql = "select count(1) from ta_process_node where process_node_code=? and id<>?";
				long count = getCountForJdbcParam(sql, param,nodeVo.getId());
				if(count > 0){
					v.setStatus("n");
					v.setInfo("节点编码已存在");
				}
			}
			if("0".equals(nodeVo.getFlag())){
				String sql = "select count(1) from ta_process_node where process_node_name=? and id<> ? and process_id = ?";
				long count = getCountForJdbcParam(sql, param,nodeVo.getId(),nodeVo.getTaProcessId());
				if(count > 0){
					v.setStatus("n");
					v.setInfo("节点名称已存在");
				}
			}
		}else{
			//新增
			if("1".equals(nodeVo.getFlag())){
				String sql = "select count(1) from ta_process_node where process_node_code=?";
				long count = getCountForJdbcParam(sql, param);
				if(count > 0){
					v.setStatus("n");
					v.setInfo("节点编码已存在");
				}
			}
			if("0".equals(nodeVo.getFlag())){
				String sql = "select count(1) from ta_process_node where process_node_name=?";
				long count = getCountForJdbcParam(sql, param);
				if(count > 0){
					v.setStatus("n");
					v.setInfo("节点名称已存在");
				}
			}
		}
		return v;
	}

	@Override
	public TaProcessNodeProEntity getTaProcessNodeByVersionKey(String processVersion, String taskDefinitionKey) {
		String hql = "from TaProcessNodeProEntity t where t.procDefId = ? and t.processNodeCode = ?";
		List <TaProcessNodeProEntity> entityList = this.findByHql(hql, processVersion, taskDefinitionKey);
		if(entityList != null && entityList.size() > 0) {
			return entityList.get(0);
		}
		return null;
	}

	@Override
	public TaProcessNodeAuthProEntity getTaProcessNodeAuthEntity(String processVersion, String processNodeId) {
		String hql = "from TaProcessNodeAuthProEntity t where t.procDefId = ? and t.processNodeId = ?";
		List <TaProcessNodeAuthProEntity> entityList = this.findByHql(hql, processVersion, processNodeId);
		if(entityList != null && entityList.size() > 0) {
			return entityList.get(0);
		}
		return null;
	}
}
