package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessEntityToTaProcessVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessVoToTaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工作流设计管理Service 接口实现.
 * <p>
 * 主要对工作流的设计信息进行CURD操作
 * @author liukai
 * @version v1.0
 */
@Service("taProcessService")
@Transactional
public class TaProcessServiceImpl extends BaseServiceImpl implements TaProcessService{

	@Autowired
	private TaProcessNodeService taProcessNodeService;
	
	@Override
	public List<TaProcessVo> findTaProcessList(TaProcessVo tpProcessVo, Page page) {
		String hql = "from TaProcessEntity where 1=1 ";
		
		List <Object> paramList = new ArrayList<Object>();
		
		if(StringUtils.isNotBlank(tpProcessVo.getProcessKey())) {
			hql += " and processKey like ?";
			paramList.add("%" + tpProcessVo.getProcessKey() + "%");
		}
		
		if(StringUtils.isNotBlank(tpProcessVo.getProcessName())) {
			hql += " and processName like ?";
			paramList.add("%" + tpProcessVo.getProcessName() + "%");
		}
		
		if(tpProcessVo.getProcessState() != null) {
			hql += " and processState = ?";
			paramList.add(tpProcessVo.getProcessState());
		}

		hql += " order by processKey";

		List <TaProcessEntity> entityList = this.findByHql(hql, page, paramList.toArray());
		
		List <TaProcessVo> voList = Lists.transform(entityList, new TaProcessEntityToTaProcessVo());
	
		return voList;
	}
	
	@Override
	public void saveTaProcess(TaProcessVo taProcessVo, Page page) {
		TaProcessEntity entity = new TaProcessVoToTaProcessEntity(this, taProcessNodeService).apply(taProcessVo);
		this.saveOrUpdate(entity);

		//清除残留节点信息
		this.clearDirtyNodeInfo(taProcessVo, entity);
	}

	/**
	 * 清除残留节点信息
	 */
	private void clearDirtyNodeInfo(TaProcessVo vo, TaProcessEntity entity) {
		String nodes = vo.getNodes();
		if (StringUtils.isNotBlank(nodes)) {
			String[] temp = nodes.split("@@@");
			Map <String, String> map = new HashMap<String, String>();

			for (int i = 0; i < temp.length; i++) {
				TaProcessNodeEntity taProcessNodeEntity = null;
				String[] fileds = temp[i].split("###");
				String tid = fileds[0].substring(3);
				map.put(tid + "_" + vo.getProcessKey(), tid + "_" + vo.getProcessKey());
			}

			List <TaProcessNodeEntity> processNodeEntityList = entity.getTaProcessNodeEntityList();
			if(CollectionUtil.listNotEmptyNotSizeZero(processNodeEntityList)) {
				for(TaProcessNodeEntity processNodeEntity : processNodeEntityList ) {
					if(!map.containsKey(processNodeEntity.getProcessNodeCode() + "_" + entity.getProcessKey())) {
						this.executeSql("delete from ta_process_node_auth where process_node_id = ?", processNodeEntity.getId());
						this.executeSql("delete from ta_process_node where id = ?", processNodeEntity.getId());
					}
				}
			}
		}
	}

	@Override
	public void deleteTaProcess(TaProcessVo taProcessVo, Page page) {
		TaProcessEntity entity = this.get(TaProcessEntity.class, taProcessVo.getId());
		this.delete(entity);
	}
	@Override
	public TaProcessVo findProcessByKey(String key) {
		String hql = "from TaProcessEntity t where t.processKey = ?";
		List<TaProcessEntity> entity = findByHql(hql, key);//以为processKey是唯一的
		TaProcessVo result = new TaProcessEntityToTaProcessVo().apply(entity.get(0));
		return result;
	}

}
