package com.biz.eisp.activiti.designer.processconf.service.impl;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.designer.processconf.entity.TaRProcessNodeListenerEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaRProcessNodeListenerService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaRProcessNodeListenerEntityToTaListenerVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaListenerVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaRProcessNodeListenerVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.google.common.collect.Lists;

/**
 * 工作流程与监听器关系管理 Service接口实现.
 * <p>
 * 
 * 主要处理工作流程与监听器关系CURD操作
 * 
 * @author liukai
 * @version v1.0
 */
@Service("taRProcessNodeListenerService")
@Transactional
public class TaRProcessNodeListenerServiceImpl extends BaseServiceImpl implements TaRProcessNodeListenerService {

	@Override
	public List<TaListenerVo> findTaProcessNodeListenerList(TaRProcessNodeListenerVo taRProcessNodeListenerVo,
			Page page) {
		String hql = "from TaRProcessNodeListenerEntity t ";
		List <TaRProcessNodeListenerEntity> entityList = this.findByHql(hql, page);
		
		List <TaListenerVo>voList = Lists.transform(entityList,
				new TaRProcessNodeListenerEntityToTaListenerVo());
		return voList;
	}

}
