package com.biz.eisp.activiti.designer.processconf.service.impl;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.mdm.web.pojo.Client;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.biz.eisp.activiti.designer.processconf.dao.TaActRoleDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.service.ProcessInputStream;
import com.biz.eisp.activiti.designer.processconf.service.TaRoleExtendService;
import com.biz.eisp.activiti.designer.processconf.service.TaRoleService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaActRoleEntityToTaActRoleVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaActRoleVoToTaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaActRoleVo;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.google.common.collect.Lists;

/** 
 * 工作流角色service实现类
 * @author wan
 * @version v1.0
 */
@SuppressWarnings("deprecation")
@Service("taRoleService")
@Transactional
public class TaRoleServcieImpl extends BaseServiceImpl implements TaRoleService{
	
	@Autowired
	private ProcessInputStream inStream;
	@Autowired(required = false)
	private RepositoryService repositoryService;
	/**
	 * 注入工作流角色dao.
	 */
	@Autowired
	private TaActRoleDao taActRoleDao;   
	/**
	 * 注入工作流角色扩展service.
	 */
	@Autowired(required=false)
	private TaRoleExtendService taRoleExtendService;   
	/*校验编码代号*/
	private static final int VALIDATE_ROLECODE = 0;
	
	/*校验名称代号*/
	private static final int VALIDATE_ROLENAME = 1;
	@Override
	public Set<String> getInXmlCandidateGroupss(String roleCode){
		//查询所有的流程定义
		List<ProcessDefinition> list = repositoryService.createProcessDefinitionQuery().list();
		List<TaProcessVo> result = new ArrayList<>();
		Set<String> set = new HashSet<>();//找到的是角色
		for(ProcessDefinition pd : list){
			InputStream is = null;
			try {
				is = inStream.getInputStream(pd);
			}catch(Exception e) {
				is = null;
			}
			
			if(is == null) {
				continue;
			}
			XMLStreamReader xtr;
			try {
				xtr = XMLInputFactory.newInstance().createXMLStreamReader(is);
				BpmnModel model = new BpmnXMLConverter().convertToBpmnModel(xtr); 
				Collection<FlowElement> elements = model.getMainProcess().getFlowElements();
				for(FlowElement fe : elements){
					if(fe instanceof UserTask){//只有usertask有assignee和candidateGroups
						UserTask ut = (UserTask)fe;
						List<String> groups = ut.getCandidateGroups();//assigness是直接设置的职位，不用查看
						for(String s : groups){
							if(roleCode.equals(s)){
								set.add(pd.getKey());
							}
						}
					}
				}
			} catch (XMLStreamException e) {
				e.printStackTrace();
			} catch (FactoryConfigurationError e) {
				e.printStackTrace();
			}
		}
		return set;
	}
	
	@Override
	public List<TaActRoleEntity> getRoleListByCurrentPosId(TaActRoleVo taActRoleVo,Page page) throws BusinessException {
		return taActRoleDao.getActRoleListByCurrentPosId(taActRoleVo, page);
	}

	@Override
	public List<TaActRoleVo> findActRoleList(TaActRoleVo taActRoleVo, Page page) {
		String hql = "from TaActRoleEntity t where 1=1 ";
		List <String> params = new ArrayList<String>();
		if(StringUtils.isNotBlank(taActRoleVo.getRoleCode())) {
			hql += " and t.roleCode like ?";
			params.add("%" + taActRoleVo.getRoleCode() + "%");
		}
		if(StringUtils.isNotBlank(taActRoleVo.getRoleName())) {
			hql += " and t.roleName like ?";
			params.add("%" + taActRoleVo.getRoleName() + "%");
		}

		hql += " order by t.roleCode";

		List <TaActRoleEntity> entityList = this.findByHql(hql, page, params.toArray());
		
		List <TaActRoleVo>voList = Lists.transform(entityList, new TaActRoleEntityToTaActRoleVo());
		
		return voList;
	}

	@Override
	public void createTmRole(TaActRoleVo taActRoleVo, Page page) throws BusinessException {
		TaActRoleEntity taActRoleEntity = null;
		//保存前扩展 此时entity还未通过vo转换
		if (StringUtil.isNotEmpty(taRoleExtendService)) {
			//验证
			try {
				taRoleExtendService.validate(taActRoleVo, page);
			} catch (Exception e) {
				throw new BusinessException("验证数据失败:"+e.getMessage());
			}
			//扩展
			taActRoleEntity = taRoleExtendService.saveBefore(taActRoleVo, page);
		}
		//如果entity为null 则通过vo转换
		if(StringUtil.isEmpty(taActRoleEntity)){
			taActRoleEntity = new TaActRoleVoToTaActRoleEntity(this).apply(taActRoleVo);
		}
		//保存前扩展 此时entity已经通过vo转换
		if(StringUtil.isNotEmpty(taRoleExtendService)){
			taActRoleEntity = taRoleExtendService.saveBefore(taActRoleEntity, taActRoleVo, page);
		}
		//保存或者更新
		saveOrUpdate(taActRoleEntity);
		//保存后扩展
		if(StringUtil.isNotEmpty(taRoleExtendService)){
			taActRoleEntity = taRoleExtendService.savePost(taActRoleEntity, taActRoleVo, page);
		}
	}

	@Override
	public boolean deleteTmRole(String id) throws SQLException {
		TaActRoleEntity roleEntity = get(TaActRoleEntity.class, id);
		if(StringUtil.isNotEmpty(roleEntity)){
			if(Globals.Admin_Name.equalsIgnoreCase(roleEntity.getRoleCode())){
				return false;
			}else{
				super.deleteEntityById(TaActRoleEntity.class, id);
			}
		}else{
			return false;
		}
		return true;
	}

	@Override
	public Map<String, String> updateTmRole(TaActRoleEntity taActRoleEntity) {
		Map<String, String> map = new HashMap<String, String>();
		// 校验角色编码
		List<TaActRoleEntity> li1 = this.validate(VALIDATE_ROLECODE, taActRoleEntity.getRoleCode());
		if (li1.size() == 0 || li1.get(0).getId().equals(taActRoleEntity.getId())) {
			// 校验角色名称
			li1 = this.validate(VALIDATE_ROLENAME, taActRoleEntity.getRoleName());
			if (li1.size() == 0 || li1.get(0).getId().equals(taActRoleEntity.getId())) {
				// 查询出对应权限角色信息
				TaActRoleEntity role = super.get(TaActRoleEntity.class, taActRoleEntity.getId());
				// 将修改过的字段赋值给查询出的对象
				role.setRoleCode(taActRoleEntity.getRoleCode());
				role.setRoleName(taActRoleEntity.getRoleName());
				// 添加修改时间
				role.setUpdateDate(new Date());
				// 添加修改人
				Client client = ResourceConfigUtils.getClient();
				String name = client.getUser().getUserName();
				role.setUpdateName(name);
				super.updateEntity(role);
				map.put("success", "true");
			} else {
				map.put("success", "false");
				map.put("msg", "角色名称重复");
			}
		} else {
			map.put("success", "false");
			map.put("msg", "角色编码重复");
		}
		return map;
	}
	/**
	 * 校验角色编码或者名称是否重复
	 * @param flag 区分校验编码与校验名称
	 * @param str 需要校验的值
	 * @return 校验结果
	 */
	public List<TaActRoleEntity> validate(int flag, String str) {
		String hql = null;
		Object[] obj = { str };
		if (flag == VALIDATE_ROLENAME) {
			hql = "from TaActRoleEntity t where t.roleName = ?";
		} else if (flag == VALIDATE_ROLECODE) {
			hql = "from TaActRoleEntity t where t.roleCode = ?";
		}
		return super.findByHql(hql, obj);
	}
	@Override
	public ValidForm validateTmRoleForm(TaActRoleEntity taActRoleEntity) {
		ValidForm validForm = new ValidForm();
		String hql = null;
		if(StringUtil.isEmpty(taActRoleEntity.getId())){
			//新增验证
			if (StringUtil.isNotEmpty(taActRoleEntity.getRoleCode())) {
				hql = "from TaActRoleEntity t where t.roleCode = ?";
				if(!CollectionUtils.isEmpty(super.findByHql(hql, taActRoleEntity.getRoleCode()))){
					validForm.setInfo("角色编码已存在");
					validForm.setStatus("n");
				}
			}
			if (StringUtil.isNotEmpty(taActRoleEntity.getRoleName())) {
				hql = "from TaActRoleEntity t where t.roleName = ?";
				if(!CollectionUtils.isEmpty(super.findByHql(hql, taActRoleEntity.getRoleName()))){
					validForm.setInfo("角色名称已存在");
					validForm.setStatus("n");
				}
			}
		}else{
			//修改验证
			if (StringUtil.isNotEmpty(taActRoleEntity.getRoleCode())) {
				hql = "from TaActRoleEntity t where t.roleCode = ? and id <> ?";
				if(!CollectionUtils.isEmpty(super.findByHql(hql, taActRoleEntity.getRoleCode(), taActRoleEntity.getId()))){
					validForm.setInfo("角色编码已存在");
					validForm.setStatus("n");
				}
			}
			if (StringUtil.isNotEmpty(taActRoleEntity.getRoleName())) {
				hql = "from TaActRoleEntity t where t.roleName = ? and id <> ?";
				if(!CollectionUtils.isEmpty(super.findByHql(hql, taActRoleEntity.getRoleName(), taActRoleEntity.getId()))){
					validForm.setInfo("角色名称已存在");
					validForm.setStatus("n");
				}
			}
		}
		
		return validForm;
	}

	@Override
	public List<TmPositionVo> findPositionByRoleCode(TmPositionVo tmPositionVo, String roleCode, Page page) {
		List <TmPositionVo> list = taActRoleDao.findPositionByRoleCode(tmPositionVo, roleCode, page);
		return list;
	}
}
