package com.biz.eisp.activiti.designer.processconf.transformer;

import com.biz.eisp.activiti.designer.processconf.entity.TaActRoleEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaRoleService;
import com.biz.eisp.activiti.designer.processconf.vo.TaActRoleVo;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.PinyinUtil;
import com.google.common.base.Function;

/**
 * 工作流角色vo转entity.
 * @author grover
 * @version v1.0
 */
public class TaActRoleVoToTaActRoleEntity implements Function<TaActRoleVo, TaActRoleEntity> {
	/**
	 * 工作流角色service.
	 */
	private TaRoleService taRoleService;
	
	public TaActRoleVoToTaActRoleEntity(TaRoleService taRoleService){
		this.taRoleService = taRoleService;
	}
	
	@Override
	public TaActRoleEntity apply(TaActRoleVo vo) {
		//验证
		if(StringUtil.isNotEmpty(vo.getRoleCode()) && !vo.getRoleCode().startsWith("BPM_")) {
			throw new BusinessException("必须以BPM_开始，输入长度2-30的英文或数字");
		}
		//实例
		TaActRoleEntity entity = new TaActRoleEntity();
		if (StringUtil.isNotEmpty(vo.getId())) {
			entity = taRoleService.get(TaActRoleEntity.class, vo.getId());
		}
		
		if(StringUtil.isEmpty(vo.getEnableState())){
			vo.setEnableStatus(Globals.ZERO);
		}
		//拼音简写
		vo.setHeadString(PinyinUtil.getPinYinHeadChar(vo.getRoleName()));
		//拷贝
		try {
			MyBeanUtils.copyBeanNotNull2Bean(vo, entity);
		} catch (Exception e) {
			e.printStackTrace();
			throw new BusinessException("拷贝工作流角色异常");
		}
		
		return entity;
	}

}
