package com.biz.eisp.activiti.designer.processconf.transformer;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.google.common.base.Function;

/** 类简述.
 * <p>类的详细说明第一行<br>
 * 类的详细说明第二行
 * @author liukai
 * @version v1.0
 */
public class TaProcessEntityToTaProcessVo  implements Function<TaProcessEntity, TaProcessVo>{

	@Override
	public TaProcessVo apply(TaProcessEntity entity) {
		TaProcessVo vo = new TaProcessVo();
		if(entity != null) {
			vo.setId(entity.getId());
			vo.setProcessKey(entity.getProcessKey());
			vo.setProcessName(entity.getProcessName());
			vo.setProcessState(entity.getProcessState());
			if(entity.getTmDictDataEntity() != null) {
				vo.setTypeId(entity.getTmDictDataEntity().getId());
				vo.setTypeName(entity.getTmDictDataEntity().getDictValue());
			}
		}
		return vo;
	}

}
