package com.biz.eisp.activiti.designer.processconf.transformer;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessFunctionAuthEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessFunctionAuthService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessFunctionAuthVo;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.google.common.base.Function;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

/**
 * Created by liukai on 2018/1/15.
 * 菜单中可以选取的流程配置 Vo 转 Entity
 *
 */
public class TaProcessFunctionAuthVoToTaProcessFunctionAuthEntity implements Function<TaProcessFunctionAuthVo, TaProcessFunctionAuthEntity> {

    private TaProcessFunctionAuthService taProcessFunctionAuthService;

    public TaProcessFunctionAuthVoToTaProcessFunctionAuthEntity() {
        taProcessFunctionAuthService = ApplicationContextUtils.getContext().getBean(TaProcessFunctionAuthService.class);
    }

    @Override
    public TaProcessFunctionAuthEntity apply(TaProcessFunctionAuthVo vo) {
        TaProcessFunctionAuthEntity entity = null;
        if(StringUtils.isNotBlank(vo.getId())) {
            entity = taProcessFunctionAuthService.get(TaProcessFunctionAuthEntity.class, vo.getId());
        } else {
            entity = new TaProcessFunctionAuthEntity();
        }

        if(StringUtils.isNotBlank(vo.getOrgId())) {
            TmOrgEntity orgEntity = taProcessFunctionAuthService.get(TmOrgEntity.class, vo.getOrgId());
            if(orgEntity != null) {
                vo.setOrgCode(orgEntity.getOrgCode());
                vo.setOrgName(orgEntity.getOrgName());
            }
        }


        BeanUtils.copyProperties(vo, entity);

        if(StringUtils.isBlank(vo.getId())) {
            entity.setId(null);
        }

        return entity;
    }
}
