package com.biz.eisp.activiti.designer.processconf.transformer;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.google.common.base.Function;

/**
 * 流程节点实体转vo
 * @author wan
 * @version v1.0
 */
public class TaProcessNodeEntityToTaProcessNodeVo implements Function<TaProcessNodeEntity, TaProcessNodeVo>{

	@Override
	public TaProcessNodeVo apply(TaProcessNodeEntity entity) {
		TaProcessNodeVo vo = new TaProcessNodeVo();
		vo.setId(entity.getId());
		vo.setProcessNodeName(entity.getProcessNodeName());
		vo.setProcessNodeCode(entity.getProcessNodeCode());
		vo.setModelandview(entity.getModelandview());
		vo.setTaProcessId(entity.getTaProcessEntity().getId());
		vo.setProcessName(entity.getTaProcessEntity().getProcessName());
		vo.setRoleCode(entity.getRoleCode());
		vo.setPositionCode(entity.getPositionCode());
		vo.setSign(entity.getSign());
		vo.setSort(entity.getSort());
		vo.setFilter(entity.getFilter());
		vo.setNullJumpNode(entity.getNullJumpNode());
		vo.setDuplicateJumpNode(entity.getDuplicateJumpNode());
		return vo;
	}

}
