package com.biz.eisp.activiti.designer.processconf.transformer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeAuthEntity;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.mdm.dict.util.DictUtil;
import org.apache.commons.lang3.StringUtils;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.utils.StreamUtils;
import com.google.common.base.Function;

/**
 * 类简述.
 * <p>
 * 类的详细说明第一行<br>
 * 类的详细说明第二行
 * 
 * @author liukai
 * @version v1.0
 */
public class TaProcessVoToTaProcessEntity implements Function<TaProcessVo, TaProcessEntity> {

	private TaProcessService taProcessService;

	private TaProcessNodeService taProcessNodeService;

	public TaProcessVoToTaProcessEntity(TaProcessService taProcessService, TaProcessNodeService taProcessNodeService) {
		this.taProcessService = taProcessService;
		this.taProcessNodeService = taProcessNodeService;
	}

	@Override
	public TaProcessEntity apply(TaProcessVo vo) {
		TaProcessEntity entity = null;

		if (vo == null) {
			return null;
		}

		if ("0".equals(vo.getId())) {
			entity = new TaProcessEntity();
			List<TaProcessEntity> list = taProcessService.findByProperty(TaProcessEntity.class, "processKey",
					vo.getProcessKey());

			if (list.size() > 0) {
				throw new BusinessException("流程Key重复了");
			}
		} else {
			entity = taProcessService.get(TaProcessEntity.class, vo.getId());
		}

		entity.setListenerClass(vo.getListenerClass());
		entity.setNote(vo.getNote());
		entity.setProcessKey(vo.getProcessKey());
		entity.setProcessName(vo.getProcessName());
		entity.setProcessState(vo.getProcessState());
		entity.setProcessXml(StreamUtils.StringTObyte(vo.getProcessDescriptor()));
		// entity.setProcessxmlpath(vo.get);
		entity.setRedirectUrl(vo.getRedirectUrl());
		entity.setTableName(vo.getTableName());

		taProcessService.save(entity);
		
		// entity.setTmUserEntity(tmUserEntity);
		// entity.setTPProcessnodes(TPProcessnodes);
		// entity.setTPProcesspros(TPProcesspros);

		String nodes = vo.getNodes();

		Map <String, String> newMap = new HashMap<String, String>();

		if (StringUtils.isNotBlank(nodes)) {
			String[] temp = nodes.split("@@@");

			for (int i = 0; i < temp.length; i++) {
				TaProcessNodeEntity taProcessNodeEntity = null;
				String[] fileds = temp[i].split("###");
				String tid = fileds[0].substring(3);
				String name = fileds[1].substring(9);
				String roleCode = null;
				if(fileds.length > 2) {
					roleCode = fileds[2].substring(9);
				}
				
				taProcessNodeEntity = taProcessNodeService.getTaProcessNodeEntity(tid, vo.getProcessKey());
				if (taProcessNodeEntity == null) {
					taProcessNodeEntity = new TaProcessNodeEntity();
					taProcessNodeEntity.setProcessNodeCode(tid);
					taProcessNodeEntity.setProcessNodeName(name);
					taProcessNodeEntity.setTaProcessEntity(entity);
					taProcessNodeEntity.setDuplicateJumpNode("N");
					taProcessNodeEntity.setNullJumpNode("N");
					taProcessService.save(taProcessNodeEntity);
				} else {
					taProcessNodeEntity.setProcessNodeCode(tid);
					taProcessNodeEntity.setProcessNodeName(name);
					taProcessNodeEntity.setTaProcessEntity(entity);
					taProcessService.updateEntity(taProcessNodeEntity);
				}

				this.saveTaProcessNodeAuth(taProcessNodeEntity);
			}
		}

		return entity;
	}

	private void saveTaProcessNodeAuth(TaProcessNodeEntity taProcessNodeEntity) {
		TaProcessNodeAuthEntity authEntity = taProcessService.
				findUniqueByProperty(TaProcessNodeAuthEntity.class, "processNodeId", taProcessNodeEntity.getId());
		if(authEntity == null) {
			authEntity = new TaProcessNodeAuthEntity();
			authEntity.setProcessNodeId(taProcessNodeEntity.getId());
			authEntity.setProcessId(taProcessNodeEntity.getTaProcessEntity().getId());

			String btn1 = DictUtil.getDicDataValue("tm_process_node_auth", "btn1") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn1");
			String btn2 = DictUtil.getDicDataValue("tm_process_node_auth", "btn2") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn2");
			String btn3 = DictUtil.getDicDataValue("tm_process_node_auth", "btn3") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn3");
			String btn4 = DictUtil.getDicDataValue("tm_process_node_auth", "btn4") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn4");
			String btn5 = DictUtil.getDicDataValue("tm_process_node_auth", "btn5") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn5");
			String btn6 = DictUtil.getDicDataValue("tm_process_node_auth", "btn6") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn6");
			String btn7 = DictUtil.getDicDataValue("tm_process_node_auth", "btn7") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn7");
			String btn8 = DictUtil.getDicDataValue("tm_process_node_auth", "btn8") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn8");
			String btn9 = DictUtil.getDicDataValue("tm_process_node_auth", "btn9") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn9");
			String btn10 = DictUtil.getDicDataValue("tm_process_node_auth", "btn10") ==  null ?
					"Y" : DictUtil.getDicDataValue("tm_process_node_auth", "btn10");

			authEntity.setBtn1(btn1);
			authEntity.setBtn2(btn2);
			authEntity.setBtn3(btn3);
			authEntity.setBtn4(btn4);
			authEntity.setBtn5(btn5);
			authEntity.setBtn6(btn6);
			authEntity.setBtn7(btn7);
			authEntity.setBtn8(btn8);
			authEntity.setBtn9(btn9);
			authEntity.setBtn10(btn10);

		}
		taProcessService.saveOrUpdate(authEntity);
	}
}
