package com.biz.eisp.activiti.designer.processconf.transformer;

import com.biz.eisp.activiti.designer.processconf.entity.TaListenerEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaRProcessNodeListenerEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaListenerVo;
import com.google.common.base.Function;

/**
 * 类简述.
 * <p>
 * 类的详细说明第一行<br>
 * 类的详细说明第二行
 * 
 * @author liukai
 * @version v1.0
 */
public class TaRProcessNodeListenerEntityToTaListenerVo
		implements Function<TaRProcessNodeListenerEntity, TaListenerVo> {

	@Override
	public TaListenerVo apply(TaRProcessNodeListenerEntity entity) {
		if (entity == null) {
			return null;
		}

		TaListenerEntity taListenerEntity = entity.getTaListenerEntity();

		TaListenerVo vo = new TaListenerVo();

		vo.setListenerEvent(taListenerEntity.getListenerEvent());
		vo.setListenerName(taListenerEntity.getListenerName());
		vo.setListenerState(taListenerEntity.getListenerState());
		vo.setListenerType(taListenerEntity.getListenerType());
		vo.setListenerValue(taListenerEntity.getListenerValue());
		vo.setId(taListenerEntity.getId());

		return vo;
	}

}
