package com.biz.eisp.activiti.designer.processconf.vo;

/**
 * Activiti在部署添加资源是，如果发布部署的文件是流程文件（.bpmn,.bpmn20.xml），
 * 其除了会将内容保存到资源表（act_ge_bytearray）外，还会解析流程文件的内容，并形成特定的流程定义数据，写入到此表中
 * <p>
 * 
 * @author wan
 * @version v1.0
 */
public class ActReProcdefVo {
	private String id;
	// 数据版本号
	private Integer rev;
	// 流程定义的分类，读取流程XML文件中的targetNamespace
	private String category;
	// 流程定义的名称，读取流程文件中process元素的name值
	private String name;
	// 流程定义的key，读取流程文件中process元素的id值
	private String key;
	// 流程定义的版本，如果同一个流程文件被多次部署，那么该版本号就会往上递增，若第一条流程定义的数据为1，那么第二条数据则为2
	private Integer version;
	// 流程定义的对应的部署数据ID
	private String deploymentId;
	// 流程定义的对应的资源名称，一般为流程文件的相对路径
	private String resourceName;
	// 流程定义的对应的流程图资源名称
	private String dgrmResourceName;
	// 描述
	private String description;
	// 流程文件是否有开始表单，可以在开始事件中使用，activiti:formkey属性来配置开始表单
	private Boolean hasStartFormKey;
	// 表示流程定义的状态是激活还是终止，激活状态时该字段值为1，终止后字段值为2，如果流程定义被设置为终止状态，那么将不能启动流程
	private Integer suspensionState;

	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	public String getCategory() {
		return this.category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getKey() {
		return this.key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public Integer getVersion() {
		return this.version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	public String getDeploymentId() {
		return this.deploymentId;
	}

	public void setDeploymentId(String deploymentId) {
		this.deploymentId = deploymentId;
	}

	public String getResourceName() {
		return this.resourceName;
	}

	public void setResourceName(String resourceName) {
		this.resourceName = resourceName;
	}

	public String getDgrmResourceName() {
		return this.dgrmResourceName;
	}

	public void setDgrmResourceName(String dgrmResourceName) {
		this.dgrmResourceName = dgrmResourceName;
	}

	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Boolean getHasStartFormKey() {
		return this.hasStartFormKey;
	}

	public void setHasStartFormKey(Boolean hasStartFormKey) {
		this.hasStartFormKey = hasStartFormKey;
	}

	public Integer getSuspensionState() {
		return this.suspensionState;
	}

	public void setSuspensionState(Integer suspensionState) {
		this.suspensionState = suspensionState;
	}
}
