package com.biz.eisp.activiti.designer.user.controller;

import com.biz.eisp.activiti.designer.user.service.TaUserService;
import com.biz.eisp.activiti.designer.user.vo.TaUserVo;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;


/** 
 * activiti管理表act_id_user的一个控制器.
 * @author wan
 * @version v1.0
 */
@Controller
@RequestMapping("/taUserController")
public class TaUserController {
	
	@Autowired
	private TaUserService taUserService;
	
	@RequestMapping(value = "findUserList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findUserList(TaUserVo taUserVo,
			HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		taUserVo.setFilterPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		List <TaUserVo> voList = taUserService.findUserList(taUserVo, page);
		return new DataGrid(voList, page);
	}
}
