package com.biz.eisp.activiti.entity.activiti;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * 用于保存与流程引擎相关的资源，只要调用Activiti存储服务的API，其提供的资源均会被转换为byte数据保存到这个表中。
 * 一般情况下，Activiti使用这个表来保存字符串，流程文件的内容和流程图片内容。
 * <p>
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_ge_bytearray")
public class ActGeBytearrayEntity implements java.io.Serializable {

	private String id;// 主键ID
	//一次部署可以添加多个资源，该字段与部署表act_ge_deployment的主键关联
	private ActReDeploymentEntity actReDeployment;
	//数据版本，Activiti为一些有可能会频繁修改的数据表加入该字段，用来标识该数据被操作的次数
	private Integer rev;
	//资源名称
	private String name;
	//资源内容，数据类型为blob，最大可存4G数据
	private String bytes;
	//是否由Activiti自动产生的资源，0表示false，1表示true
	private Boolean generated;
	private Set<ActReModelEntity> actReModelsForEditorSourceExtraValueId = new HashSet<ActReModelEntity>(0);
	private Set<ActReModelEntity> actReModelsForEditorSourceValueId = new HashSet<ActReModelEntity>(0);
	private Set<ActRuJobEntity> actRuJobs = new HashSet<ActRuJobEntity>(0);
	private Set<ActRuVariableEntity> actRuVariables = new HashSet<ActRuVariableEntity>(0);

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	@Column(name = "id_", unique = true, nullable = false, length = 64)
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "deployment_id_")
	public ActReDeploymentEntity getActReDeployment() {
		return this.actReDeployment;
	}

	public void setActReDeployment(ActReDeploymentEntity actReDeployment) {
		this.actReDeployment = actReDeployment;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	@Column(name = "name_")
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "bytes_")
	public String getBytes() {
		return this.bytes;
	}

	public void setBytes(String bytes) {
		this.bytes = bytes;
	}

	@Column(name = "generated_")
	public Boolean getGenerated() {
		return this.generated;
	}

	public void setGenerated(Boolean generated) {
		this.generated = generated;
	}

	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "actGeBytearrayByEditorSourceExtraValueId")
	public Set<ActReModelEntity> getActReModelsForEditorSourceExtraValueId() {
		return this.actReModelsForEditorSourceExtraValueId;
	}

	public void setActReModelsForEditorSourceExtraValueId(Set<ActReModelEntity> actReModelsForEditorSourceExtraValueId) {
		this.actReModelsForEditorSourceExtraValueId = actReModelsForEditorSourceExtraValueId;
	}

	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "actGeBytearrayByEditorSourceValueId")
	public Set<ActReModelEntity> getActReModelsForEditorSourceValueId() {
		return this.actReModelsForEditorSourceValueId;
	}

	public void setActReModelsForEditorSourceValueId(Set<ActReModelEntity> actReModelsForEditorSourceValueId) {
		this.actReModelsForEditorSourceValueId = actReModelsForEditorSourceValueId;
	}

	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "actGeBytearray")
	public Set<ActRuJobEntity> getActRuJobs() {
		return this.actRuJobs;
	}

	public void setActRuJobs(Set<ActRuJobEntity> actRuJobs) {
		this.actRuJobs = actRuJobs;
	}

	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "actGeBytearray")
	public Set<ActRuVariableEntity> getActRuVariables() {
		return this.actRuVariables;
	}

	public void setActRuVariables(Set<ActRuVariableEntity> actRuVariables) {
		this.actRuVariables = actRuVariables;
	}

}
