package com.biz.eisp.activiti.entity.activiti;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * Activiti将全部的属性抽象为key-value对，每个属性都有名称和值，使用此表来进行保存
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_ge_property")
public class ActGePropertyEntity implements java.io.Serializable {

	// 属性名称
	private String name;
	// 属性值
	private String value;
	// 数据的版本号
	private Integer rev;

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "value_", length = 300)
	public String getValue() {
		return this.value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

}
