package com.biz.eisp.activiti.entity.activiti;

import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * 使用任务服务（TaskService）的API，可以添加附件和评论，这些附件和评论的数据将会保存到act_hi_attachment（附件）和此表中
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_hi_comment")
public class ActHiCommentEntity implements java.io.Serializable {

	private String id;
	// 评论的类型，可以设置为event或者commont，表示事件记录数据或者评论数据
	private String type;
	// 数据产生的时间
	private Timestamp time;
	// 产生评论数据的用户id
	private String userId;
	// 该评论数据的任务id
	private String taskId;
	// 数据对应的流程实例i
	private String procInstId;
	// 该评论数据的操作标识
	private String action;
	// 该评论数据的信息
	private String message;
	// 该字段同样记录评论数据的信息
	private String fullMsg;

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Column(name = "type_")
	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "time_", nullable = false, length = 29)
	public Timestamp getTime() {
		return this.time;
	}

	public void setTime(Timestamp time) {
		this.time = time;
	}

	@Column(name = "user_id_")
	public String getUserId() {
		return this.userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	@Column(name = "task_id_", length = 64)
	public String getTaskId() {
		return this.taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	@Column(name = "proc_inst_id_", length = 64)
	public String getProcInstId() {
		return this.procInstId;
	}

	public void setProcInstId(String procInstId) {
		this.procInstId = procInstId;
	}

	@Column(name = "action_")
	public String getAction() {
		return this.action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	@Column(name = "message_", length = 4000)
	public String getMessage() {
		return this.message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	@Column(name = "full_msg_")
	public String getFullMsg() {
		return this.fullMsg;
	}

	public void setFullMsg(String fullMsg) {
		this.fullMsg = fullMsg;
	}

}
