package com.biz.eisp.activiti.entity.activiti;

import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.hibernate.annotations.GenericGenerator;

/**
 * 流程实例的历史数据会被保存到此表中，只要流程被启动，Activiti就会将流程实例的数据写入此表中。
 * 除了基本的流程字段外，与运行时数据表不同的是，历史流程实例表还会记录流程的开始活动id，结束活动id等信息
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_hi_procinst", uniqueConstraints = {
		@UniqueConstraint(columnNames = { "proc_def_id_", "business_key_" }),
		@UniqueConstraint(columnNames = "proc_inst_id_") })
public class ActHiProcinstEntity implements java.io.Serializable {

	private String id;// 主键ID
	// 流程实例id，一个流程实例有可能会产生多个执行流，该字段表示执行流所属的流程实例。
	private String procInstId;
	// 启动流程时指定的业务主键
	private String businessKey;
	// 流程定义数据的ID
	private String procDefId;
	// 开始时间
	private Timestamp startTime;
	// 结束时间
	private Timestamp endTime;
	// 持续时间
	private Long duration;

	private String startUserId;
	// 开始活动的id，一般是流程开始事件的id，在流程文件中定义
	private String startActId;
	// 流程最后一个活动的id，一般是流程结束事件id，在流程文件中定义
	private String endActId;
	// 父流程实例ID
	private String superProcessInstanceId;
	// 删除原因
	private String deleteReason;

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	@Column(name = "id_", unique = true, nullable = false, length = 64)
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Column(name = "proc_inst_id_", unique = true, nullable = false, length = 64)
	public String getProcInstId() {
		return this.procInstId;
	}

	public void setProcInstId(String procInstId) {
		this.procInstId = procInstId;
	}

	@Column(name = "business_key_")
	public String getBusinessKey() {
		return this.businessKey;
	}

	public void setBusinessKey(String businessKey) {
		this.businessKey = businessKey;
	}

	@Column(name = "proc_def_id_", nullable = false, length = 64)
	public String getProcDefId() {
		return this.procDefId;
	}

	public void setProcDefId(String procDefId) {
		this.procDefId = procDefId;
	}

	@Column(name = "start_time_", nullable = false, length = 29)
	public Timestamp getStartTime() {
		return this.startTime;
	}

	public void setStartTime(Timestamp startTime) {
		this.startTime = startTime;
	}

	@Column(name = "end_time_", length = 29)
	public Timestamp getEndTime() {
		return this.endTime;
	}

	public void setEndTime(Timestamp endTime) {
		this.endTime = endTime;
	}

	@Column(name = "duration_")
	public Long getDuration() {
		return this.duration;
	}

	public void setDuration(Long duration) {
		this.duration = duration;
	}

	@Column(name = "start_user_id_")
	public String getStartUserId() {
		return this.startUserId;
	}

	public void setStartUserId(String startUserId) {
		this.startUserId = startUserId;
	}

	@Column(name = "start_act_id_")
	public String getStartActId() {
		return this.startActId;
	}

	public void setStartActId(String startActId) {
		this.startActId = startActId;
	}

	@Column(name = "end_act_id_")
	public String getEndActId() {
		return this.endActId;
	}

	public void setEndActId(String endActId) {
		this.endActId = endActId;
	}

	@Column(name = "super_process_instance_id_", length = 64)
	public String getSuperProcessInstanceId() {
		return this.superProcessInstanceId;
	}

	public void setSuperProcessInstanceId(String superProcessInstanceId) {
		this.superProcessInstanceId = superProcessInstanceId;
	}

	@Column(name = "delete_reason_", length = 4000)
	public String getDeleteReason() {
		return this.deleteReason;
	}

	public void setDeleteReason(String deleteReason) {
		this.deleteReason = deleteReason;
	}

}
