package com.biz.eisp.activiti.entity.activiti;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * 流程变量历史表
 */
@Entity
@Table(name = "act_hi_varinst")
public class ActHiVarinstEntity implements java.io.Serializable {

	private String id;
	// 该参数对应的流程实例id，可以为null
	private String procInstId;
	// 该参数对应的执行id，可以为null
	private String executionId;
	// 如果该参数是任务参数，就需要设置任务id
	private String taskId;
	// 参数名称
	private String name;
	// 参数类型，该字段值可以为boolean，bytes，serializable，date，double，interger，jpa-entity，long，null，short，string，这些字段均为Activiti提供，还可以通过自定义来扩展参数类型
	private String varType;
	// 数据版本号
	private Integer rev;
	// 如果参数值是序列化对象，那么可以将该对象作为资源保存到资源表中，该字段保存资源表中的数据id
	private String bytearrayId;
	// 参数类型为double，则值会保存到该字段中
	private Double double_;
	// 参数类型为long，则值会保存到该字段中
	private Long long_;
	// 用于保存文本类型的参数值
	private String text;
	// 与text_字段一样，用于保存文本类型的参数值
	private String text2;

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Column(name = "proc_inst_id_", length = 64)
	public String getProcInstId() {
		return this.procInstId;
	}

	public void setProcInstId(String procInstId) {
		this.procInstId = procInstId;
	}

	@Column(name = "execution_id_", length = 64)
	public String getExecutionId() {
		return this.executionId;
	}

	public void setExecutionId(String executionId) {
		this.executionId = executionId;
	}

	@Column(name = "task_id_", length = 64)
	public String getTaskId() {
		return this.taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	@Column(name = "name_", nullable = false)
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "var_type_", length = 100)
	public String getVarType() {
		return this.varType;
	}

	public void setVarType(String varType) {
		this.varType = varType;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	@Column(name = "bytearray_id_", length = 64)
	public String getBytearrayId() {
		return this.bytearrayId;
	}

	public void setBytearrayId(String bytearrayId) {
		this.bytearrayId = bytearrayId;
	}

	@Column(name = "double_", precision = 17, scale = 17)
	public Double getDouble_() {
		return this.double_;
	}

	public void setDouble_(Double double_) {
		this.double_ = double_;
	}

	@Column(name = "long_")
	public Long getLong_() {
		return this.long_;
	}

	public void setLong_(Long long_) {
		this.long_ = long_;
	}

	@Column(name = "text_", length = 4000)
	public String getText() {
		return this.text;
	}

	public void setText(String text) {
		this.text = text;
	}

	@Column(name = "text2_", length = 4000)
	public String getText2() {
		return this.text2;
	}

	public void setText2(String text2) {
		this.text2 = text2;
	}

}
