package com.biz.eisp.activiti.entity.activiti;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * Activiti 将用户、用户账号和用户信息分为三种数据。其中用户表保存用户的数据。而用户账号和用户信息则保存到此表中
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_id_info")
public class ActIdInfoEntity implements java.io.Serializable {

	private String id;
	//数据版本号
	private Integer rev;
	//对应用户表的数据id，但没有强制作外键关联
	private String userId;
	//信息类型，当前可以设置用户账号（account），用户信息（userinfo），和null三种值
	private String type;
	//数据的键，可以根据该键来查找用户信息的值
	private String key;
	//数据的值
	private String value;
	//用户账号的密码字段，不过当前版本的Activiti并没有使用该字段
	private String password;
	//该信息的父信息id，如果一条数据设置了父信息id，则表示该数据是用户账号（信息）的明细数据。例如一个账号有激活日志，那么激活日期就是该账号的明细数据，此处使用了自关联来实现
	private String parentId;

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	@Column(name = "user_id_", length = 64)
	public String getUserId() {
		return this.userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	@Column(name = "type_", length = 64)
	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "key_")
	public String getKey() {
		return this.key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Column(name = "value_")
	public String getValue() {
		return this.value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	@Column(name = "password_")
	public String getPassword() {
		return this.password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	@Column(name = "parent_id_")
	public String getParentId() {
		return this.parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

}
