package com.biz.eisp.activiti.entity.activiti;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 一个用户组可以有多个用户，同时一个用户也可以属于不同用户组，那么这种多对多的关系，就使用关系表来进行描述
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_id_membership")
public class ActIdMembershipEntity implements java.io.Serializable {

	// 用户id，不能为空
	private ActIdGroupEntity actIdGroup;
	// 用户组id，不能为空
	private ActIdUserEntity actIdUser;

	@Id
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "group_id_", nullable = false, insertable = false, updatable = false)
	public ActIdGroupEntity getActIdGroup() {
		return this.actIdGroup;
	}

	public void setActIdGroup(ActIdGroupEntity actIdGroup) {
		this.actIdGroup = actIdGroup;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "user_id_", nullable = false, insertable = false, updatable = false)
	public ActIdUserEntity getActIdUser() {
		return this.actIdUser;
	}

	public void setActIdUser(ActIdUserEntity actIdUser) {
		this.actIdUser = actIdUser;
	}

}
