package com.biz.eisp.activiti.entity.activiti;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * 流程引擎用户的信息被保存到此表中
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_id_user")
public class ActIdUserEntity implements java.io.Serializable {

	//主键，由Activiti来定义生成策略
	private String id;
	//数据版本号
	private Integer rev;
	//名字的名称
	private String first;
	//名字的姓氏
	private String last;
	//邮箱
	private String email;
	//用户密码
	private String pwd;
	//用户图片，对应资源（act_ge_bytearray）中的id
	private String pictureId;
	private Set<ActIdMembershipEntity> actIdMemberships = new HashSet<ActIdMembershipEntity>(0);

	@Id
	@Column(name = "id_")
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	@Column(name = "first_")
	public String getFirst() {
		return this.first;
	}

	public void setFirst(String first) {
		this.first = first;
	}

	@Column(name = "last_")
	public String getLast() {
		return this.last;
	}

	public void setLast(String last) {
		this.last = last;
	}

	@Column(name = "email_")
	public String getEmail() {
		return this.email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	@Column(name = "pwd_")
	public String getPwd() {
		return this.pwd;
	}

	public void setPwd(String pwd) {
		this.pwd = pwd;
	}

	@Column(name = "picture_id_", length = 64)
	public String getPictureId() {
		return this.pictureId;
	}

	public void setPictureId(String pictureId) {
		this.pictureId = pictureId;
	}

	@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER, mappedBy = "actIdUser")
	public Set<ActIdMembershipEntity> getActIdMemberships() {
		return this.actIdMemberships;
	}

	public void setActIdMemberships(Set<ActIdMembershipEntity> actIdMemberships) {
		this.actIdMemberships = actIdMemberships;
	}

}
