package com.biz.eisp.activiti.entity.activiti;

import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * 模型信息
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_re_model")
public class ActReModelEntity implements java.io.Serializable {
	private String id;
	private ActGeBytearrayEntity actGeBytearrayByEditorSourceExtraValueId;
	private ActGeBytearrayEntity actGeBytearrayByEditorSourceValueId;
	private ActReDeploymentEntity actReDeployment;
	//数据版本号
	private Integer rev;
	//模型的名称：比如：收文管理
	private String name;
	//模型的关键字，流程引擎用到。比如：FTOA_SWGL
	private String key;
	//类型，用户自己对流程模型的分类。
	private String category;
	//创建时间
	private Timestamp createTime;
	//最后修改时间
	private Timestamp lastUpdateTime;
	//流程定义的版本，如果同一个流程文件被多次部署，那么该版本号就会往上递增，若第一条流程定义的数据为1，那么第二条数据则为2
	private Integer version;
	//数据源信息，比如：{"name":"FTOA_SWGL","revision":1,"description":"丰台财政局OA，收文管理流程"}
	private String metaInfo;

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "editor_source_extra_value_id_")
	public ActGeBytearrayEntity getActGeBytearrayByEditorSourceExtraValueId() {
		return this.actGeBytearrayByEditorSourceExtraValueId;
	}

	public void setActGeBytearrayByEditorSourceExtraValueId(
			ActGeBytearrayEntity actGeBytearrayByEditorSourceExtraValueId) {
		this.actGeBytearrayByEditorSourceExtraValueId = actGeBytearrayByEditorSourceExtraValueId;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "editor_source_value_id_")
	public ActGeBytearrayEntity getActGeBytearrayByEditorSourceValueId() {
		return this.actGeBytearrayByEditorSourceValueId;
	}

	public void setActGeBytearrayByEditorSourceValueId(ActGeBytearrayEntity actGeBytearrayByEditorSourceValueId) {
		this.actGeBytearrayByEditorSourceValueId = actGeBytearrayByEditorSourceValueId;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "deployment_id_")
	public ActReDeploymentEntity getActReDeployment() {
		return this.actReDeployment;
	}

	public void setActReDeployment(ActReDeploymentEntity actReDeployment) {
		this.actReDeployment = actReDeployment;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	@Column(name = "name_")
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "key_")
	public String getKey() {
		return this.key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	@Column(name = "category_")
	public String getCategory() {
		return this.category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	@Column(name = "create_time_", length = 29)
	public Timestamp getCreateTime() {
		return this.createTime;
	}

	public void setCreateTime(Timestamp createTime) {
		this.createTime = createTime;
	}

	@Column(name = "last_update_time_", length = 29)
	public Timestamp getLastUpdateTime() {
		return this.lastUpdateTime;
	}

	public void setLastUpdateTime(Timestamp lastUpdateTime) {
		this.lastUpdateTime = lastUpdateTime;
	}

	@Column(name = "version_")
	public Integer getVersion() {
		return this.version;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	@Column(name = "meta_info_", length = 4000)
	public String getMetaInfo() {
		return this.metaInfo;
	}

	public void setMetaInfo(String metaInfo) {
		this.metaInfo = metaInfo;
	}

}
