package com.biz.eisp.activiti.entity.activiti;

import java.sql.Timestamp;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * 如果流程到达莫类事件节点，Activiti会往此表加入事件描述数据，这些事件描述数据将会决定流程事件的触发
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_ru_event_subscr")
public class ActRuEventSubscrEntity implements java.io.Serializable {

	private String id;
	// 事件所在的执行流id
	private ActRuExecutionEntity actRuExecution;
	// 数据版本号
	private Integer rev;
	// 事件类型，不同的事件会产生不同类型的事件描述，并不是全部的事件都会产生事件描述
	private String eventType;
	// 事件名称，在流程文件中定义
	private String eventName;
	// 事件所在的流程实例id
	private String procInstId;
	// 具体事件id，在流程文件中定义
	private String activityId;
	// 事件的配置属性，该字段有可能存放流程定义id，执行流id或者其他数据
	private String configuration;
	// 事件的创建时间
	private Timestamp created;

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "execution_id_")
	public ActRuExecutionEntity getActRuExecution() {
		return this.actRuExecution;
	}

	public void setActRuExecution(ActRuExecutionEntity actRuExecution) {
		this.actRuExecution = actRuExecution;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	@Column(name = "event_type_", nullable = false)
	public String getEventType() {
		return this.eventType;
	}

	public void setEventType(String eventType) {
		this.eventType = eventType;
	}

	@Column(name = "event_name_")
	public String getEventName() {
		return this.eventName;
	}

	public void setEventName(String eventName) {
		this.eventName = eventName;
	}

	@Column(name = "proc_inst_id_", length = 64)
	public String getProcInstId() {
		return this.procInstId;
	}

	public void setProcInstId(String procInstId) {
		this.procInstId = procInstId;
	}

	@Column(name = "activity_id_", length = 64)
	public String getActivityId() {
		return this.activityId;
	}

	public void setActivityId(String activityId) {
		this.activityId = activityId;
	}

	@Column(name = "configuration_")
	public String getConfiguration() {
		return this.configuration;
	}

	public void setConfiguration(String configuration) {
		this.configuration = configuration;
	}

	@Column(name = "created_", nullable = false, length = 29)
	public Timestamp getCreated() {
		return this.created;
	}

	public void setCreated(Timestamp created) {
		this.created = created;
	}

}
