package com.biz.eisp.activiti.entity.activiti;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.GenericGenerator;

/**
 * 用户或者用户组与流程数据之间的关系使用此表保存
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "act_ru_identitylink")
public class ActRuIdentitylinkEntity implements java.io.Serializable {

	private String id;
	// 关系数据中的流程定义id
	private ActReProcdefEntity actReProcdef;
	// 关系数据中的任务id
	private ActRuTaskEntity actRuTask;
	// 数据版本号
	private Integer rev;
	// 该关系数据中的用户组id
	private String groupId;
	// 该关系数据的类型，当前提供了3个值：assignee，candidate，owner，表示流程数据的指派人（组），候选人（组）和拥有人
	private String type;
	// 关系数据中的用户id
	private String userId;

	@Id
	@GeneratedValue(generator = "hibernate-uuid")
	@GenericGenerator(name = "hibernate-uuid", strategy = "uuid")
	public String getId() {
		return this.id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "proc_def_id_")
	public ActReProcdefEntity getActReProcdef() {
		return this.actReProcdef;
	}

	public void setActReProcdef(ActReProcdefEntity actReProcdef) {
		this.actReProcdef = actReProcdef;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "task_id_")
	public ActRuTaskEntity getActRuTask() {
		return this.actRuTask;
	}

	public void setActRuTask(ActRuTaskEntity actRuTask) {
		this.actRuTask = actRuTask;
	}

	@Column(name = "rev_")
	public Integer getRev() {
		return this.rev;
	}

	public void setRev(Integer rev) {
		this.rev = rev;
	}

	@Column(name = "group_id_")
	public String getGroupId() {
		return this.groupId;
	}

	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	@Column(name = "type_")
	public String getType() {
		return this.type;
	}

	public void setType(String type) {
		this.type = type;
	}

	@Column(name = "user_id_")
	public String getUserId() {
		return this.userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

}
